/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.app;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.app.ApplicationService;
import org.onosproject.app.ApplicationState;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.core.Application;

@Command(scope="onos", name="apps", description="Lists application information")
public class ApplicationsListCommand
extends AbstractShellCommand {
    private static final String FMT = "%s id=%d, name=%s, version=%s, origin=%s, description=%s, features=%s, featuresRepo=%s, permissions=%s";

    @Override
    protected void execute() {
        ApplicationService service = ApplicationsListCommand.get(ApplicationService.class);
        ArrayList apps = Lists.newArrayList((Iterable)service.getApplications());
        Collections.sort(apps, Comparators.APP_COMPARATOR);
        if (this.outputJson()) {
            this.print("%s", this.json(service, apps));
        } else {
            for (Application app : apps) {
                this.print(FMT, service.getState(app.id()) == ApplicationState.ACTIVE ? "*" : " ", app.id().id(), app.id().name(), app.version(), app.origin(), app.description(), app.features(), app.featuresRepo().isPresent() ? ((URI)app.featuresRepo().get()).toString() : "", app.permissions());
            }
        }
    }

    private JsonNode json(ApplicationService service, List<Application> apps) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Application app : apps) {
            result.add(this.json(service, mapper, app));
        }
        return result;
    }

    protected JsonNode json(ApplicationService service, ObjectMapper mapper, Application app) {
        return mapper.createObjectNode().put("name", app.id().name()).put("id", app.id().id()).put("version", app.version().toString()).put("description", app.description()).put("origin", app.origin()).put("permissions", app.permissions().toString()).put("featuresRepo", app.featuresRepo().isPresent() ? ((URI)app.featuresRepo().get()).toString() : "").put("features", app.features().toString()).put("state", service.getState(app.id()).toString());
    }
}

