/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.cfg;

import com.google.common.base.Strings;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cli.AbstractShellCommand;

@Command(scope="onos", name="cfg", description="Manages component configuration")
public class ComponentConfigCommand
extends AbstractShellCommand {
    static final String GET = "get";
    static final String SET = "set";
    private static final String FMT = "    name=%s, type=%s, value=%s, defaultValue=%s, description=%s";
    @Argument(index=0, name="command", description="Command name (activate|deactivate|uninstall)", required=false, multiValued=false)
    String command = null;
    @Argument(index=1, name="component", description="Component name", required=false, multiValued=false)
    String component = null;
    @Argument(index=2, name="name", description="Property name", required=false, multiValued=false)
    String name = null;
    @Argument(index=3, name="value", description="Property value", required=false, multiValued=false)
    String value = null;
    ComponentConfigService service;

    @Override
    protected void execute() {
        this.service = ComponentConfigCommand.get(ComponentConfigService.class);
        if (Strings.isNullOrEmpty((String)this.command)) {
            this.listComponents();
        } else if (this.command.equals(GET) && Strings.isNullOrEmpty((String)this.component)) {
            this.listAllComponentsProperties();
        } else if (this.command.equals(GET) && Strings.isNullOrEmpty((String)this.name)) {
            this.listComponentProperties(this.component);
        } else if (this.command.equals(GET)) {
            this.listComponentProperty(this.component, this.name);
        } else if (this.command.equals(SET) && Strings.isNullOrEmpty((String)this.value)) {
            this.service.unsetProperty(this.component, this.name);
        } else if (this.command.equals(SET)) {
            this.service.setProperty(this.component, this.name, this.value);
        } else {
            this.error("Illegal usage", new Object[0]);
        }
    }

    private void listAllComponentsProperties() {
        this.service.getComponentNames().forEach(this::listComponentProperties);
    }

    private void listComponents() {
        this.service.getComponentNames().forEach(n -> this.print("%s", n));
    }

    private void listComponentProperties(String component) {
        Set props = this.service.getProperties(component);
        this.print("%s", component);
        props.forEach(p -> this.print(FMT, p.name(), p.type().toString().toLowerCase(), p.value(), p.defaultValue(), p.description()));
    }

    private void listComponentProperty(String component, String name) {
    }
}

