/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.List;
import java.util.Optional;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.MplsLabel;
import org.onosproject.cli.net.ConnectivityIntentCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.MplsIntent;

@Command(scope="onos", name="add-mpls-intent", description="Installs mpls connectivity intent")
public class AddMplsIntent
extends ConnectivityIntentCommand {
    @Argument(index=0, name="ingressDevice", description="Ingress Device/Port Description", required=true, multiValued=false)
    private String ingressDeviceString = null;
    @Option(name="--ingressLabel", description="Ingress Mpls label", required=false, multiValued=false)
    private String ingressLabelString = "";
    @Argument(index=1, name="egressDevice", description="Egress Device/Port Description", required=true, multiValued=false)
    private String egressDeviceString = null;
    @Option(name="--egressLabel", description="Egress Mpls label", required=false, multiValued=false)
    private String egressLabelString = "";

    @Override
    protected void execute() {
        IntentService service = AddMplsIntent.get(IntentService.class);
        DeviceId ingressDeviceId = DeviceId.deviceId((String)AddMplsIntent.getDeviceId(this.ingressDeviceString));
        PortNumber ingressPortNumber = PortNumber.portNumber((String)AddMplsIntent.getPortNumber(this.ingressDeviceString));
        ConnectPoint ingress = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
        Optional<Object> ingressLabel = Optional.empty();
        if (!this.ingressLabelString.isEmpty()) {
            ingressLabel = Optional.ofNullable(MplsLabel.mplsLabel((int)this.parseInt(this.ingressLabelString)));
        }
        DeviceId egressDeviceId = DeviceId.deviceId((String)AddMplsIntent.getDeviceId(this.egressDeviceString));
        PortNumber egressPortNumber = PortNumber.portNumber((String)AddMplsIntent.getPortNumber(this.egressDeviceString));
        ConnectPoint egress = new ConnectPoint((ElementId)egressDeviceId, egressPortNumber);
        Optional<Object> egressLabel = Optional.empty();
        if (!this.ingressLabelString.isEmpty()) {
            egressLabel = Optional.ofNullable(MplsLabel.mplsLabel((int)this.parseInt(this.egressLabelString)));
        }
        TrafficSelector selector = this.buildTrafficSelector();
        TrafficTreatment treatment = this.buildTrafficTreatment();
        List<Constraint> constraints = this.buildConstraints();
        MplsIntent intent = new MplsIntent(this.appId(), selector, treatment, ingress, ingressLabel, egress, egressLabel, constraints);
        service.submit((Intent)intent);
    }

    public static String getPortNumber(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(slash + 1, deviceString.length());
    }

    public static String getDeviceId(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(0, slash);
    }

    protected Integer parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

