/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.HashSet;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.net.ConnectivityIntentCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;

@Command(scope="onos", name="add-multi-to-single-intent", description="Installs point-to-point connectivity intent")
public class AddMultiPointToSinglePointIntentCommand
extends ConnectivityIntentCommand {
    @Argument(index=0, name="ingressDevices egressDevice", description="ingressDevice/Port..ingressDevice/Port egressDevice/Port", required=true, multiValued=true)
    String[] deviceStrings = null;

    @Override
    protected void execute() {
        IntentService service = AddMultiPointToSinglePointIntentCommand.get(IntentService.class);
        if (this.deviceStrings.length < 2) {
            return;
        }
        String egressDeviceString = this.deviceStrings[this.deviceStrings.length - 1];
        DeviceId egressDeviceId = DeviceId.deviceId((String)this.getDeviceId(egressDeviceString));
        PortNumber egressPortNumber = PortNumber.portNumber((String)this.getPortNumber(egressDeviceString));
        ConnectPoint egress = new ConnectPoint((ElementId)egressDeviceId, egressPortNumber);
        HashSet<ConnectPoint> ingressPoints = new HashSet<ConnectPoint>();
        for (int index = 0; index < this.deviceStrings.length - 1; ++index) {
            String ingressDeviceString = this.deviceStrings[index];
            DeviceId ingressDeviceId = DeviceId.deviceId((String)this.getDeviceId(ingressDeviceString));
            PortNumber ingressPortNumber = PortNumber.portNumber((String)this.getPortNumber(ingressDeviceString));
            ConnectPoint ingress = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
            ingressPoints.add(ingress);
        }
        TrafficSelector selector = this.buildTrafficSelector();
        TrafficTreatment treatment = this.buildTrafficTreatment();
        List<Constraint> constraints = this.buildConstraints();
        MultiPointToSinglePointIntent intent = new MultiPointToSinglePointIntent(this.appId(), this.key(), selector, treatment, ingressPoints, egress, constraints, this.priority());
        service.submit((Intent)intent);
        this.print("Multipoint to single point intent submitted:\n%s", intent.toString());
    }

    private String getPortNumber(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(slash + 1, deviceString.length());
    }

    private String getDeviceId(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(0, slash);
    }
}

