/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.net.ConnectivityIntentCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.PointToPointIntent;

@Command(scope="onos", name="add-point-intent", description="Installs point-to-point connectivity intent")
public class AddPointToPointIntentCommand
extends ConnectivityIntentCommand {
    @Argument(index=0, name="ingressDevice", description="Ingress Device/Port Description", required=true, multiValued=false)
    String ingressDeviceString = null;
    @Argument(index=1, name="egressDevice", description="Egress Device/Port Description", required=true, multiValued=false)
    String egressDeviceString = null;

    @Override
    protected void execute() {
        IntentService service = AddPointToPointIntentCommand.get(IntentService.class);
        DeviceId ingressDeviceId = DeviceId.deviceId((String)AddPointToPointIntentCommand.getDeviceId(this.ingressDeviceString));
        PortNumber ingressPortNumber = PortNumber.portNumber((String)AddPointToPointIntentCommand.getPortNumber(this.ingressDeviceString));
        ConnectPoint ingress = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
        DeviceId egressDeviceId = DeviceId.deviceId((String)AddPointToPointIntentCommand.getDeviceId(this.egressDeviceString));
        PortNumber egressPortNumber = PortNumber.portNumber((String)AddPointToPointIntentCommand.getPortNumber(this.egressDeviceString));
        ConnectPoint egress = new ConnectPoint((ElementId)egressDeviceId, egressPortNumber);
        TrafficSelector selector = this.buildTrafficSelector();
        TrafficTreatment treatment = this.buildTrafficTreatment();
        List<Constraint> constraints = this.buildConstraints();
        PointToPointIntent intent = new PointToPointIntent(this.appId(), this.key(), selector, treatment, ingress, egress, constraints, this.priority());
        service.submit((Intent)intent);
        this.print("Point to point intent submitted:\n%s", intent.toString());
    }

    public static String getPortNumber(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(slash + 1, deviceString.length());
    }

    public static String getDeviceId(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(0, slash);
    }
}

