/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.HashSet;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.net.ConnectivityIntentCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;

@Command(scope="onos", name="add-single-to-multi-intent", description="Installs connectivity intent between a single ingress device and multiple egress devices")
public class AddSinglePointToMultiPointIntentCommand
extends ConnectivityIntentCommand {
    @Argument(index=0, name="ingressDevice egressDevices", description="ingressDevice/Port egressDevice/Port...egressDevice/Port", required=true, multiValued=true)
    String[] deviceStrings = null;

    @Override
    protected void execute() {
        IntentService service = AddSinglePointToMultiPointIntentCommand.get(IntentService.class);
        if (this.deviceStrings.length < 2) {
            return;
        }
        String ingressDeviceString = this.deviceStrings[0];
        DeviceId ingressDeviceId = DeviceId.deviceId((String)this.getDeviceId(ingressDeviceString));
        PortNumber ingressPortNumber = PortNumber.portNumber((String)this.getPortNumber(ingressDeviceString));
        ConnectPoint ingressPoint = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
        HashSet<ConnectPoint> egressPoints = new HashSet<ConnectPoint>();
        for (int index = 1; index < this.deviceStrings.length; ++index) {
            String egressDeviceString = this.deviceStrings[index];
            DeviceId egressDeviceId = DeviceId.deviceId((String)this.getDeviceId(egressDeviceString));
            PortNumber egressPortNumber = PortNumber.portNumber((String)this.getPortNumber(egressDeviceString));
            ConnectPoint egress = new ConnectPoint((ElementId)egressDeviceId, egressPortNumber);
            egressPoints.add(egress);
        }
        TrafficSelector selector = this.buildTrafficSelector();
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        List<Constraint> constraints = this.buildConstraints();
        SinglePointToMultiPointIntent intent = new SinglePointToMultiPointIntent(this.appId(), this.key(), selector, treatment, ingressPoint, egressPoints, constraints, this.priority());
        service.submit((Intent)intent);
        this.print("Single point to multipoint intent submitted:\n%s", intent.toString());
    }

    private String getPortNumber(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(slash + 1, deviceString.length());
    }

    private String getDeviceId(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(0, slash);
    }
}

