/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.net.ClustersListCommand;
import org.onosproject.cli.net.LinksListCommand;
import org.onosproject.net.Link;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.TopologyCluster;

@Command(scope="onos", name="cluster-links", description="Lists links of the specified topology cluster in the current topology")
public class ClusterLinksCommand
extends ClustersListCommand {
    @Argument(index=0, name="id", description="Cluster ID", required=true, multiValued=false)
    String id = null;

    @Override
    protected void execute() {
        int cid = Integer.parseInt(this.id);
        this.init();
        TopologyCluster cluster = this.service.getCluster(this.topology, ClusterId.clusterId((int)cid));
        if (cluster == null) {
            this.error("No such cluster %s", cid);
        } else if (this.outputJson()) {
            this.print("%s", LinksListCommand.json(this.service.getClusterLinks(this.topology, cluster)));
        } else {
            for (Link link : this.service.getClusterLinks(this.topology, cluster)) {
                this.print(LinksListCommand.linkString(link), new Object[0]);
            }
        }
    }
}

