/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import java.util.LinkedList;
import java.util.List;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.EthType;
import org.onosproject.cli.net.IpProtocol;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.Link;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.intent.constraint.LambdaConstraint;
import org.onosproject.net.intent.constraint.LinkTypeConstraint;
import org.onosproject.net.resource.Bandwidth;

public abstract class ConnectivityIntentCommand
extends AbstractShellCommand {
    @Option(name="-s", aliases={"--ethSrc"}, description="Source MAC Address", required=false, multiValued=false)
    private String srcMacString = null;
    @Option(name="-d", aliases={"--ethDst"}, description="Destination MAC Address", required=false, multiValued=false)
    private String dstMacString = null;
    @Option(name="-t", aliases={"--ethType"}, description="Ethernet Type", required=false, multiValued=false)
    private String ethTypeString = null;
    @Option(name="--ipProto", description="IP Protocol", required=false, multiValued=false)
    private String ipProtoString = null;
    @Option(name="--ipSrc", description="Source IP Address", required=false, multiValued=false)
    private String srcIpString = null;
    @Option(name="--ipDst", description="Destination IP Address", required=false, multiValued=false)
    private String dstIpString = null;
    @Option(name="--tcpSrc", description="Source TCP Port", required=false, multiValued=false)
    private String srcTcpString = null;
    @Option(name="--tcpDst", description="Destination TCP Port", required=false, multiValued=false)
    private String dstTcpString = null;
    @Option(name="-b", aliases={"--bandwidth"}, description="Bandwidth", required=false, multiValued=false)
    private String bandwidthString = null;
    @Option(name="-l", aliases={"--lambda"}, description="Lambda", required=false, multiValued=false)
    private boolean lambda = false;
    @Option(name="-k", aliases={"--key"}, description="Intent Key", required=false, multiValued=false)
    private String intentKey = null;
    @Option(name="--setEthSrc", description="Rewrite Source MAC Address", required=false, multiValued=false)
    private String setEthSrcString = null;
    @Option(name="--setEthDst", description="Rewrite Destination MAC Address", required=false, multiValued=false)
    private String setEthDstString = null;
    @Option(name="-p", aliases={"--priority"}, description="Priority", required=false, multiValued=false)
    private int priority = 100;

    protected TrafficSelector buildTrafficSelector() {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        short ethType = EthType.IPV4.value();
        if (!Strings.isNullOrEmpty((String)this.ethTypeString)) {
            ethType = EthType.parseFromString(this.ethTypeString);
        }
        selectorBuilder.matchEthType(ethType);
        if (!Strings.isNullOrEmpty((String)this.srcMacString)) {
            selectorBuilder.matchEthSrc(MacAddress.valueOf((String)this.srcMacString));
        }
        if (!Strings.isNullOrEmpty((String)this.dstMacString)) {
            selectorBuilder.matchEthDst(MacAddress.valueOf((String)this.dstMacString));
        }
        if (!Strings.isNullOrEmpty((String)this.ipProtoString)) {
            short ipProtoShort = IpProtocol.parseFromString(this.ipProtoString);
            selectorBuilder.matchIPProtocol((byte)ipProtoShort);
        }
        if (!Strings.isNullOrEmpty((String)this.srcIpString)) {
            selectorBuilder.matchIPSrc(IpPrefix.valueOf((String)this.srcIpString));
        }
        if (!Strings.isNullOrEmpty((String)this.dstIpString)) {
            selectorBuilder.matchIPDst(IpPrefix.valueOf((String)this.dstIpString));
        }
        if (!Strings.isNullOrEmpty((String)this.srcTcpString)) {
            selectorBuilder.matchTcpSrc((short)Integer.parseInt(this.srcTcpString));
        }
        if (!Strings.isNullOrEmpty((String)this.dstTcpString)) {
            selectorBuilder.matchTcpDst((short)Integer.parseInt(this.dstTcpString));
        }
        return selectorBuilder.build();
    }

    protected TrafficTreatment buildTrafficTreatment() {
        boolean hasEthDst;
        boolean hasEthSrc = !Strings.isNullOrEmpty((String)this.setEthSrcString);
        boolean bl = hasEthDst = !Strings.isNullOrEmpty((String)this.setEthDstString);
        if (!hasEthSrc && !hasEthDst) {
            return DefaultTrafficTreatment.emptyTreatment();
        }
        TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
        if (hasEthSrc) {
            MacAddress setEthSrc = MacAddress.valueOf((String)this.setEthSrcString);
            builder.setEthSrc(setEthSrc);
        }
        if (hasEthDst) {
            MacAddress setEthDst = MacAddress.valueOf((String)this.setEthDstString);
            builder.setEthDst(setEthDst);
        }
        return builder.build();
    }

    protected List<Constraint> buildConstraints() {
        LinkedList<Constraint> constraints = new LinkedList<Constraint>();
        if (!Strings.isNullOrEmpty((String)this.bandwidthString)) {
            double bandwidthValue = Double.parseDouble(this.bandwidthString);
            constraints.add((Constraint)new BandwidthConstraint(Bandwidth.bps((double)bandwidthValue)));
        }
        if (this.lambda) {
            constraints.add((Constraint)new LambdaConstraint(null));
        }
        constraints.add((Constraint)new LinkTypeConstraint(this.lambda, new Link.Type[]{Link.Type.OPTICAL}));
        return constraints;
    }

    protected Key key() {
        Key key = null;
        if (this.intentKey != null) {
            key = Key.of((String)this.intentKey, (ApplicationId)this.appId());
        }
        return key;
    }

    protected int priority() {
        return this.priority;
    }
}

