/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.Comparators;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.instructions.Instruction;

@Command(scope="onos", name="flows", description="Lists all currently-known flows.")
public class FlowsListCommand
extends AbstractShellCommand {
    public static final String ANY = "any";
    private static final String FMT = "   id=%s, state=%s, bytes=%s, packets=%s, duration=%s, priority=%s, tableId=%s appId=%s";
    private static final String TFMT = "      treatment=%s";
    private static final String SFMT = "      selector=%s";
    @Argument(index=1, name="uri", description="Device ID", required=false, multiValued=false)
    String uri = null;
    @Argument(index=0, name="state", description="Flow Rule state", required=false, multiValued=false)
    String state = null;

    @Override
    protected void execute() {
        CoreService coreService = FlowsListCommand.get(CoreService.class);
        DeviceService deviceService = FlowsListCommand.get(DeviceService.class);
        FlowRuleService service = FlowsListCommand.get(FlowRuleService.class);
        SortedMap<Device, List<FlowEntry>> flows = this.getSortedFlows(deviceService, service);
        if (this.outputJson()) {
            this.print("%s", this.json(coreService, flows.keySet(), flows));
        } else {
            flows.forEach((device, flow) -> this.printFlows((Device)device, (List<FlowEntry>)flow, coreService));
        }
    }

    private JsonNode json(CoreService coreService, Iterable<Device> devices, Map<Device, List<FlowEntry>> flows) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Device device : devices) {
            result.add((JsonNode)this.json(coreService, mapper, device, flows.get(device)));
        }
        return result;
    }

    private ObjectNode json(CoreService coreService, ObjectMapper mapper, Device device, List<FlowEntry> flows) {
        ObjectNode result = mapper.createObjectNode();
        ArrayNode array = mapper.createArrayNode();
        for (FlowEntry flow : flows) {
            array.add((JsonNode)this.json(coreService, mapper, flow));
        }
        result.put("device", device.id().toString()).put("flowCount", flows.size()).set("flows", (JsonNode)array);
        return result;
    }

    private ObjectNode json(CoreService coreService, ObjectMapper mapper, FlowEntry flow) {
        ObjectNode result = mapper.createObjectNode();
        ArrayNode crit = mapper.createArrayNode();
        for (Object c : flow.selector().criteria()) {
            crit.add(c.toString());
        }
        ArrayNode instr = mapper.createArrayNode();
        for (Instruction i : flow.treatment().instructions()) {
            instr.add(i.toString());
        }
        ApplicationId appCoreId = coreService.getAppId(Short.valueOf(flow.appId()));
        String appName = appCoreId == null ? Short.toString(flow.appId()) : appCoreId.name();
        result.put("flowId", Long.toHexString(flow.id().value())).put("state", flow.state().toString()).put("bytes", flow.bytes()).put("packets", flow.packets()).put("life", flow.life()).put("tableId", flow.type().toString()).put("appId", appName);
        result.set("selector", (JsonNode)crit);
        result.set("treatment", (JsonNode)instr);
        return result;
    }

    protected SortedMap<Device, List<FlowEntry>> getSortedFlows(DeviceService deviceService, FlowRuleService service) {
        TreeMap<Element, ArrayList> flows = new TreeMap<Element, ArrayList>(Comparators.ELEMENT_COMPARATOR);
        FlowEntry.FlowEntryState s = null;
        if (this.state != null && !this.state.equals(ANY)) {
            s = FlowEntry.FlowEntryState.valueOf((String)this.state.toUpperCase());
        }
        List<Device> devices = this.uri == null ? deviceService.getDevices() : Collections.singletonList(deviceService.getDevice(DeviceId.deviceId((String)this.uri)));
        for (Device d : devices) {
            ArrayList rules;
            if (s == null) {
                rules = Lists.newArrayList((Iterable)service.getFlowEntries(d.id()));
            } else {
                rules = Lists.newArrayList();
                for (FlowEntry f : service.getFlowEntries(d.id())) {
                    if (!f.state().equals((Object)s)) continue;
                    rules.add(f);
                }
            }
            rules.sort(Comparators.FLOW_RULE_COMPARATOR);
            flows.put((Element)d, rules);
        }
        return flows;
    }

    protected void printFlows(Device d, List<FlowEntry> flows, CoreService coreService) {
        boolean empty = flows == null || flows.isEmpty();
        this.print("deviceId=%s, flowRuleCount=%d", d.id(), empty ? 0 : flows.size());
        if (!empty) {
            for (FlowEntry f : flows) {
                this.print(FMT, Long.toHexString(f.id().value()), f.state(), f.bytes(), f.packets(), f.life(), f.priority(), f.type(), coreService.getAppId(Short.valueOf(f.appId())).name());
                this.print(SFMT, f.selector().criteria());
                this.print(TFMT, f.treatment());
            }
        }
    }
}

