/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupService;

@Command(scope="onos", name="groups", description="Lists all groups in the system")
public class GroupsListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "   key=%s, id=%s, state=%s, bytes=%s, packets=%s, appId=%s, buckets=%s";

    @Override
    protected void execute() {
        DeviceService deviceService = GroupsListCommand.get(DeviceService.class);
        GroupService groupService = GroupsListCommand.get(GroupService.class);
        deviceService.getDevices().forEach(d -> this.printGroups(d.id(), groupService.getGroups(d.id())));
    }

    private void printGroups(DeviceId deviceId, Iterable<Group> groups) {
        this.print("deviceId=%s", deviceId);
        for (Group group : groups) {
            this.print(FORMAT, group.appCookie(), group.id(), group.state(), group.bytes(), group.packets(), group.appId(), group.buckets());
        }
    }
}

