/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;

@Command(scope="onos", name="remove-intent", description="Removes the specified intent")
public class IntentRemoveCommand
extends AbstractShellCommand {
    @Argument(index=0, name="app", description="Application ID", required=true, multiValued=false)
    String applicationIdString = null;
    @Argument(index=1, name="id", description="Intent ID", required=true, multiValued=false)
    String id = null;
    @Option(name="-p", aliases={"--purge"}, description="Purge the intent from the store after removal", required=false, multiValued=false)
    private boolean purgeAfterRemove = false;
    @Option(name="-s", aliases={"--sync"}, description="Waits for the removal before returning", required=false, multiValued=false)
    private boolean sync = false;

    @Override
    protected void execute() {
        Key key;
        Intent intent;
        IntentService intentService = IntentRemoveCommand.get(IntentService.class);
        CoreService coreService = IntentRemoveCommand.get(CoreService.class);
        ApplicationId appId = this.appId();
        if (this.applicationIdString != null && (appId = coreService.getAppId(this.applicationIdString)) == null) {
            this.print("Cannot find application Id %s", this.applicationIdString);
            return;
        }
        if (this.id.startsWith("0x")) {
            this.id = this.id.replaceFirst("0x", "");
        }
        if ((intent = intentService.getIntent(key = Key.of((long)new BigInteger(this.id, 16).longValue(), (ApplicationId)appId))) != null) {
            CountDownLatch purgeLatch;
            CountDownLatch withdrawLatch;
            IntentListener listener = null;
            if (this.purgeAfterRemove || this.sync) {
                withdrawLatch = new CountDownLatch(1);
                purgeLatch = this.purgeAfterRemove ? new CountDownLatch(1) : null;
                listener = event -> {
                    if (Objects.equals(((Intent)event.subject()).key(), key)) {
                        if (event.type() == IntentEvent.Type.WITHDRAWN || event.type() == IntentEvent.Type.FAILED) {
                            withdrawLatch.countDown();
                        } else if (this.purgeAfterRemove && event.type() == IntentEvent.Type.PURGED) {
                            purgeLatch.countDown();
                        }
                    }
                };
                intentService.addListener(listener);
            } else {
                purgeLatch = null;
                withdrawLatch = null;
            }
            intentService.withdraw(intent);
            if (this.purgeAfterRemove || this.sync) {
                try {
                    withdrawLatch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.print("Timed out waiting for intent {} withdraw", key);
                }
                IntentState state = intentService.getIntentState(key);
                if (this.purgeAfterRemove && (state == IntentState.WITHDRAWN || state == IntentState.FAILED)) {
                    intentService.purge(intent);
                }
                if (this.sync) {
                    try {
                        purgeLatch.await(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        this.print("Timed out waiting for intent {} purge", key);
                    }
                }
            }
            if (listener != null) {
                intentService.removeListener(listener);
            }
        }
    }
}

