/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

public enum IpProtocol {
    ICMP(1),
    TCP(6),
    UDP(17);

    private short value;

    private IpProtocol(short value) {
        this.value = value;
    }

    public short value() {
        return this.value;
    }

    public static short parseFromString(String input) {
        try {
            return IpProtocol.valueOf(input).value();
        }
        catch (IllegalArgumentException e) {
            try {
                return Short.parseShort(input);
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException("IpProtocol value must be either a string protocol name or an 8-bit protocol value");
            }
        }
    }
}

