/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Comparator;
import java.util.Map;
import org.apache.karaf.shell.commands.Command;
import org.onlab.util.Tools;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipService;

@Command(scope="onos", name="leaders", description="Finds the leader for particular topic.")
public class LeaderCommand
extends AbstractShellCommand {
    private static final String FMT = "%-20s | %-15s | %-6s | %-10s |";
    private Comparator<Leadership> leadershipComparator = (e1, e2) -> {
        if (e1.leader() == null && e2.leader() == null) {
            return 0;
        }
        if (e1.leader() == null) {
            return 1;
        }
        if (e2.leader() == null) {
            return -1;
        }
        return e1.leader().toString().compareTo(e2.leader().toString());
    };

    private void displayLeaders(Map<String, Leadership> leaderBoard) {
        this.print("--------------------------------------------------------------", new Object[0]);
        this.print(FMT, "Topic", "Leader", "Epoch", "Elected");
        this.print("--------------------------------------------------------------", new Object[0]);
        leaderBoard.values().stream().sorted(this.leadershipComparator).forEach(l -> this.print(FMT, l.topic(), l.leader(), l.epoch(), Tools.timeAgo((long)l.electedTime())));
        this.print("--------------------------------------------------------------", new Object[0]);
    }

    private JsonNode json(Map<String, Leadership> leaderBoard) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        leaderBoard.values().stream().sorted(this.leadershipComparator).forEach(l -> result.add((JsonNode)mapper.createObjectNode().put("topic", l.topic()).put("leader", l.leader().toString()).put("epoch", l.epoch()).put("electedTime", Tools.timeAgo((long)l.electedTime()))));
        return result;
    }

    @Override
    protected void execute() {
        LeadershipService leaderService = LeaderCommand.get(LeadershipService.class);
        Map leaderBoard = leaderService.getLeaderBoard();
        if (this.outputJson()) {
            this.print("%s", this.json(leaderBoard));
        } else {
            this.displayLeaders(leaderBoard);
        }
    }
}

