/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.link.LinkService;

@Command(scope="onos", name="links", description="Lists all infrastructure links")
public class LinksListCommand
extends AbstractShellCommand {
    private static final String FMT = "src=%s/%s, dst=%s/%s, type=%s, state=%s%s";
    private static final String COMPACT = "%s/%s-%s/%s";
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    String uri = null;

    @Override
    protected void execute() {
        Iterable links;
        LinkService service = LinksListCommand.get(LinkService.class);
        Iterable iterable = links = this.uri != null ? service.getDeviceLinks(DeviceId.deviceId((String)this.uri)) : service.getLinks();
        if (this.outputJson()) {
            this.print("%s", LinksListCommand.json(links));
        } else {
            for (Link link : links) {
                this.print(LinksListCommand.linkString(link), new Object[0]);
            }
        }
    }

    public static JsonNode json(Iterable<Link> links) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Link link : links) {
            result.add((JsonNode)LinksListCommand.json(mapper, link));
        }
        return result;
    }

    public static ObjectNode json(ObjectMapper mapper, Link link) {
        ObjectNode result = mapper.createObjectNode();
        result.set("src", (JsonNode)LinksListCommand.json(mapper, link.src()));
        result.set("dst", (JsonNode)LinksListCommand.json(mapper, link.dst()));
        result.put("type", link.type().toString());
        result.put("state", link.state().toString());
        result.set("annotations", (JsonNode)LinksListCommand.annotations(mapper, link.annotations()));
        return result;
    }

    public static ObjectNode json(ObjectMapper mapper, HostId hostId) {
        return mapper.createObjectNode().put("mac", hostId.mac().toString()).put("vlanId", hostId.vlanId().toString());
    }

    public static ObjectNode json(ObjectMapper mapper, ConnectPoint connectPoint) {
        return mapper.createObjectNode().put("device", connectPoint.deviceId().toString()).put("port", connectPoint.port().toString());
    }

    public static String linkString(Link link) {
        return String.format(FMT, link.src().deviceId(), link.src().port(), link.dst().deviceId(), link.dst().port(), link.type(), link.state(), LinksListCommand.annotations(link.annotations()));
    }

    public static String compactLinkString(Link link) {
        return String.format(COMPACT, link.src().deviceId(), link.src().port(), link.dst().deviceId(), link.dst().port());
    }
}

