/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyProvider;
import org.onosproject.net.topology.TopologyService;

@Command(scope="onos", name="topology", description="Lists summary of the current topology")
public class TopologyCommand
extends AbstractShellCommand {
    private static final String FMT = "created=%s, uptime=%s, devices=%d, links=%d, clusters=%d";
    @Option(name="-r", aliases={"--recompute"}, description="Trigger topology re-computation", required=false, multiValued=false)
    private boolean recompute = false;
    protected TopologyService service;
    protected Topology topology;

    protected void init() {
        this.service = TopologyCommand.get(TopologyService.class);
        this.topology = this.service.currentTopology();
    }

    @Override
    protected void execute() {
        this.init();
        long topologyUptime = Math.max(0L, System.currentTimeMillis() - this.topology.creationTime());
        if (this.recompute) {
            TopologyCommand.get(TopologyProvider.class).triggerRecompute();
        } else if (this.outputJson()) {
            this.print("%s", new ObjectMapper().createObjectNode().put("time", this.topology.time()).put("created", TopologyCommand.formatCreationTime(this.topology.creationTime())).put("uptime", TopologyCommand.formatElapsedTime(topologyUptime)).put("deviceCount", this.topology.deviceCount()).put("linkCount", this.topology.linkCount()).put("clusterCount", this.topology.clusterCount()));
        } else {
            this.print(FMT, TopologyCommand.formatCreationTime(this.topology.creationTime()), TopologyCommand.formatElapsedTime(topologyUptime), this.topology.deviceCount(), this.topology.linkCount(), this.topology.clusterCount());
        }
    }

    private static String formatElapsedTime(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("Interval less than zero. Possible unsynchronized timestamps");
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder topologyUptimeString = new StringBuilder(64);
        topologyUptimeString.append(days);
        topologyUptimeString.append(" days, ");
        topologyUptimeString.append(hours);
        topologyUptimeString.append(" hrs, ");
        topologyUptimeString.append(minutes);
        topologyUptimeString.append(" mins, ");
        topologyUptimeString.append(seconds);
        topologyUptimeString.append(" secs");
        return topologyUptimeString.toString();
    }

    private static String formatCreationTime(long millis) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return dateFormatter.format(calendar.getTime());
    }
}

