/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualHost;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;

@Command(scope="onos", name="vnet-hosts", description="Lists all virtual hosts in a virtual network.")
public class VirtualHostListCommand
extends AbstractShellCommand {
    private static final String FMT_VIRTUAL_HOST = "id=%s, mac=%s, vlan=%s, location=%s, ips=%s";
    @Argument(index=0, name="networkId", description="Network ID", required=true, multiValued=false)
    Long networkId = null;

    @Override
    protected void execute() {
        this.getSortedVirtualHosts().forEach(this::printVirtualHost);
    }

    private List<VirtualHost> getSortedVirtualHosts() {
        VirtualNetworkService service = VirtualHostListCommand.get(VirtualNetworkService.class);
        ArrayList<VirtualHost> virtualHosts = new ArrayList<VirtualHost>();
        virtualHosts.addAll(service.getVirtualHosts(NetworkId.networkId((long)this.networkId)));
        return virtualHosts;
    }

    private void printVirtualHost(VirtualHost virtualHost) {
        this.print(FMT_VIRTUAL_HOST, virtualHost.id().toString(), virtualHost.mac().toString(), virtualHost.vlan().toString(), virtualHost.location().toString(), virtualHost.ipAddresses().toString());
    }
}

