/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.packet.PacketRequest;
import org.onosproject.net.packet.PacketService;

@Command(scope="onos", name="packet-requests", description="Lists packet requests")
public class PacketRequestsListCommand
extends AbstractShellCommand {
    private static final String FMT = "nodeId=%s appId=%s, priority=%s, criteria=%s";

    @Override
    protected void execute() {
        PacketService service = PacketRequestsListCommand.get(PacketService.class);
        if (this.outputJson()) {
            this.print("%s", this.json(service.getRequests()));
        } else {
            service.getRequests().forEach(this::print);
        }
    }

    private JsonNode json(List<PacketRequest> requests) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (PacketRequest r : requests) {
            result.add((JsonNode)mapper.createObjectNode().put("nodeId", r.nodeId().toString()).put("appId", r.appId().name()).put("priority", r.priority().toString()).put("criteria", r.selector().criteria().toString()));
        }
        return result;
    }

    private void print(PacketRequest request) {
        this.print(FMT, request.nodeId(), request.appId().name(), request.priority(), request.selector().criteria());
    }
}

