/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.onlab.packet.Ethernet;

public enum EthType {
    ARP(Ethernet.TYPE_ARP),
    RARP(Ethernet.TYPE_RARP),
    IPV4(Ethernet.TYPE_IPV4),
    IPV6(Ethernet.TYPE_IPV6),
    LLDP(Ethernet.TYPE_LLDP),
    BSN(Ethernet.TYPE_BSN);

    private short value;

    private EthType(short value) {
        this.value = value;
    }

    public short value() {
        return this.value;
    }

    public static short parseFromString(String input) {
        try {
            return EthType.valueOf(input).value();
        }
        catch (IllegalArgumentException e) {
            try {
                return (short)Integer.parseInt(input);
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException("EthType value must be either a string protocol name or a 16-bit protocol value");
            }
        }
    }
}

