/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="interfaces", description="Lists all configured interfaces.")
public class InterfacesListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "%s: port=%s/%s";
    private static final String IP_FORMAT = " ips=";
    private static final String MAC_FORMAT = " mac=";
    private static final String VLAN_FORMAT = " vlan=";
    private static final String VLAN_UNTAGGED = " vlanUntagged=";
    private static final String VLAN_TAGGED = " vlanTagged=";
    private static final String VLAN_NATIVE = " vlanNative=";
    private static final String NO_NAME = "(unamed)";

    @Override
    protected void execute() {
        InterfaceService interfaceService = InterfacesListCommand.get(InterfaceService.class);
        ArrayList interfaces = Lists.newArrayList((Iterable)interfaceService.getInterfaces());
        Collections.sort(interfaces, Comparators.INTERFACES_COMPARATOR);
        interfaces.forEach(this::printInterface);
    }

    private void printInterface(Interface intf) {
        StringBuilder formatStringBuilder = new StringBuilder(FORMAT);
        if (!intf.ipAddresses().isEmpty()) {
            formatStringBuilder.append(IP_FORMAT);
            formatStringBuilder.append(intf.ipAddresses().toString());
        }
        if (!intf.mac().equals((Object)MacAddress.NONE)) {
            formatStringBuilder.append(MAC_FORMAT);
            formatStringBuilder.append(intf.mac().toString());
        }
        if (!intf.vlan().equals((Object)VlanId.NONE)) {
            formatStringBuilder.append(VLAN_FORMAT);
            formatStringBuilder.append(intf.vlan().toString());
        }
        if (!intf.vlanUntagged().equals((Object)VlanId.NONE)) {
            formatStringBuilder.append(VLAN_UNTAGGED);
            formatStringBuilder.append(intf.vlanUntagged().toString());
        }
        if (!intf.vlanTagged().isEmpty()) {
            formatStringBuilder.append(VLAN_TAGGED);
            formatStringBuilder.append(intf.vlanTagged().toString());
        }
        if (!intf.vlanNative().equals((Object)VlanId.NONE)) {
            formatStringBuilder.append(VLAN_NATIVE);
            formatStringBuilder.append(intf.vlanNative().toString());
        }
        String name = intf.name().equals("") ? NO_NAME : intf.name();
        this.print(formatStringBuilder.toString(), name, intf.connectPoint().deviceId(), intf.connectPoint().port());
    }
}

