/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.service.StorageAdminService;

@Command(scope="onos", name="counters", description="Lists information about atomic counters in the system")
public class CountersListCommand
extends AbstractShellCommand {
    private static final String FMT = "name=%s value=%d";

    @Override
    protected void execute() {
        StorageAdminService storageAdminService = CountersListCommand.get(StorageAdminService.class);
        Map counters = storageAdminService.getCounters();
        if (this.outputJson()) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode jsonCounters = mapper.createObjectNode();
            counters.forEach((k, v) -> jsonCounters.put(k, v));
            this.print("%s", jsonCounters);
        } else {
            counters.keySet().stream().sorted().forEach(name -> this.print(FMT, name, counters.get(name)));
        }
    }
}

