/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.ui.UiTopoLayoutService;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.onosproject.ui.model.topo.UiTopoLayoutId;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="layouts", description="List layout details")
public class LayoutListCommand
extends AbstractShellCommand {
    private static final String FMT = "id=%s, bgref=%s, region=%s, parent=%s";
    @Argument(index=0, name="id", description="Layout ID", required=false, multiValued=false)
    String id = null;
    private UiTopoLayoutService layoutService;

    @Override
    protected void execute() {
        this.layoutService = LayoutListCommand.get(UiTopoLayoutService.class);
        if (this.id == null) {
            for (UiTopoLayout layout : this.getSortedLayouts(this.layoutService)) {
                this.printLayout(layout);
            }
        } else {
            UiTopoLayout layout = this.layoutService.getLayout(UiTopoLayoutId.layoutId((String)this.id));
            if (layout == null) {
                this.error("No such region %s", this.id);
            } else {
                this.printLayout(layout);
            }
        }
    }

    private List<UiTopoLayout> getSortedLayouts(UiTopoLayoutService service) {
        ArrayList layouts = Lists.newArrayList((Iterable)service.getLayouts());
        Collections.sort(layouts, Comparators.LAYOUT_COMPARATOR);
        return layouts;
    }

    private void printLayout(UiTopoLayout layout) {
        String map = layout.geomap();
        String spr = layout.sprites();
        String bgRef = ".";
        if (map != null) {
            bgRef = "@" + map;
        } else if (spr != null) {
            bgRef = "+" + spr;
        }
        String pid = layout.parent() != null ? (String)layout.parent().id() : "(none)";
        this.print(FMT, layout.id(), bgRef, layout.regionId(), pid);
    }
}

