/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.cfg;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.util.Optional;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cfg.ConfigProperty;
import org.onosproject.cli.AbstractShellCommand;

@Command(scope="onos", name="cfg", description="Manages component configuration")
public class ComponentConfigCommand
extends AbstractShellCommand {
    static final String GET = "get";
    static final String SET = "set";
    private static final String FMT = "    name=%s, type=%s, value=%s, defaultValue=%s, description=%s";
    private static final String SHORT_FMT = "    %s=%s";
    @Option(name="-s", aliases={"--short"}, description="Show short output only", required=false, multiValued=false)
    private boolean shortOnly = false;
    @Argument(index=0, name="command", description="Command name (get|set)", required=false, multiValued=false)
    String command = null;
    @Argument(index=1, name="component", description="Component name", required=false, multiValued=false)
    String component = null;
    @Argument(index=2, name="name", description="Property name", required=false, multiValued=false)
    String name = null;
    @Argument(index=3, name="value", description="Property value", required=false, multiValued=false)
    String value = null;
    ComponentConfigService service;

    @Override
    protected void execute() {
        this.service = ComponentConfigCommand.get(ComponentConfigService.class);
        try {
            if (Strings.isNullOrEmpty((String)this.command)) {
                this.listComponents();
            } else if (this.command.equals(GET) && Strings.isNullOrEmpty((String)this.component)) {
                this.listAllComponentsProperties();
            } else if (this.command.equals(GET) && Strings.isNullOrEmpty((String)this.name)) {
                this.listComponentProperties(this.component);
            } else if (this.command.equals(GET)) {
                this.listComponentProperty(this.component, this.name);
            } else if (this.command.equals(SET) && Strings.isNullOrEmpty((String)this.value)) {
                this.service.unsetProperty(this.component, this.name);
            } else if (this.command.equals(SET)) {
                this.service.setProperty(this.component, this.name, this.value);
            } else {
                this.error("Illegal usage", new Object[0]);
            }
        }
        catch (IllegalArgumentException e) {
            this.error(e.getMessage(), new Object[0]);
        }
    }

    private void listAllComponentsProperties() {
        if (this.outputJson()) {
            this.print("%s", this.jsonComponentProperties());
        } else {
            this.service.getComponentNames().forEach(this::listComponentProperties);
        }
    }

    private JsonNode jsonProperty(ConfigProperty configProperty, ObjectMapper mapper) {
        return mapper.createObjectNode().put("name", configProperty.name()).put("type", configProperty.type().toString().toLowerCase()).put("value", configProperty.value()).put("defaultValue", configProperty.defaultValue()).put("description", configProperty.description());
    }

    private JsonNode jsonComponent(String component, ObjectMapper mapper) {
        ObjectNode node = mapper.createObjectNode().put("componentName", component);
        ArrayNode propertiesJson = node.putArray("properties");
        Set properties = this.service.getProperties(component);
        if (properties != null) {
            properties.forEach(configProperty -> propertiesJson.add(this.jsonProperty((ConfigProperty)configProperty, mapper)));
        }
        return node;
    }

    private JsonNode jsonComponentProperties() {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        this.service.getComponentNames().forEach(component -> result.add(this.jsonComponent((String)component, mapper)));
        return result;
    }

    private void listComponents() {
        if (this.outputJson()) {
            ArrayNode node = new ObjectMapper().createArrayNode();
            this.service.getComponentNames().forEach(arg_0 -> ((ArrayNode)node).add(arg_0));
            this.print("%s", node);
        } else {
            this.service.getComponentNames().forEach(n -> this.print("%s", n));
        }
    }

    private void listComponentProperties(String component) {
        if (this.outputJson()) {
            this.print("%s", this.jsonComponent(component, new ObjectMapper()));
        } else {
            Set props = this.service.getProperties(component);
            this.print("%s", component);
            if (props == null) {
                this.print("No properties for component " + component + " found", new Object[0]);
            } else if (this.shortOnly) {
                props.forEach(p -> this.print(SHORT_FMT, p.name(), p.value()));
            } else {
                props.forEach(p -> this.print(FMT, p.name(), p.type().toString().toLowerCase(), p.value(), p.defaultValue(), p.description()));
            }
        }
    }

    private void listComponentProperty(String component, String name) {
        Set props = this.service.getProperties(component);
        if (props == null) {
            return;
        }
        Optional<ConfigProperty> property = props.stream().filter(p -> p.name().equals(name)).findFirst();
        if (this.outputJson()) {
            this.print("%s", this.jsonProperty(property.get(), new ObjectMapper()));
        } else {
            if (!property.isPresent()) {
                this.print("Property " + name + " for component " + component + " not found", new Object[0]);
                return;
            }
            ConfigProperty p2 = property.get();
            if (this.shortOnly) {
                this.print(SHORT_FMT, p2.name(), p2.value());
            } else {
                this.print(FMT, p2.name(), p2.type().toString().toLowerCase(), p2.value(), p2.defaultValue(), p2.description());
            }
        }
    }
}

