/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

public enum Icmp6Code {
    NO_ROUTE(0),
    COMM_PROHIBIT(1),
    BEYOND_SCOPE(2),
    ADDR_UNREACH(3),
    PORT_UNREACH(4),
    FAIL_POLICY(5),
    REJECT_ROUTE(6),
    SRC_ROUTING_HEADER_ERR(7),
    HOP_LIMIT_EXCEED(0),
    DEFRAG_TIME_EXCEED(1),
    HDR_FIELD_ERR(0),
    NEXT_HEADER_ERR(1),
    IPV6_OPT_ERR(1);

    private byte value;

    private Icmp6Code(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    public static byte parseFromString(String input) {
        try {
            return Icmp6Code.valueOf(input).value();
        }
        catch (IllegalArgumentException e) {
            try {
                return Byte.parseByte(input);
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException("Icmp6Code value must be either a string code name or an 8-bit code value");
            }
        }
    }
}

