/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicRegionConfig;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionAdminService;
import org.onosproject.net.region.RegionId;

@Command(scope="onos", name="region-add", description="Adds a new region.")
public class RegionAddCommand
extends AbstractShellCommand {
    private static final String E_BAD_LOC_TYPE = "locType must be {geo|grid}";
    private static final String GEO = "geo";
    private static final String GRID = "grid";
    private static final String SLASH = "/";
    private static final BiMap<String, Region.Type> REGION_TYPE_MAP = HashBiMap.create();
    @Argument(index=0, name="id", description="Region ID", required=true, multiValued=false)
    String id = null;
    @Argument(index=1, name="name", description="Region Name", required=true, multiValued=false)
    String name = null;
    @Argument(index=2, name="type", description="Region Type (CONTINENT|COUNTRY|METRO|CAMPUS|BUILDING|DATA_CENTER|FLOOR|ROOM|RACK|LOGICAL_GROUP)", required=true, multiValued=false)
    String type = null;
    @Argument(index=3, name="latOrY", description="Geo latitude / Grid y-coord", required=true, multiValued=false)
    Double latOrY = null;
    @Argument(index=4, name="longOrX", description="Geo longitude / Grid x-coord", required=true, multiValued=false)
    Double longOrX = null;
    @Argument(index=5, name="locType", description="Location type {geo|grid}", required=false, multiValued=false)
    String locType = "geo";
    @Argument(index=6, name="masters", description="Region Master, a set of nodeIds should be split with '/' delimiter (e.g., 1 2 3 / 4 5 6)", required=true, multiValued=true)
    List<String> masterArgs = null;

    @Override
    protected void execute() {
        RegionAdminService service = RegionAddCommand.get(RegionAdminService.class);
        RegionId regionId = RegionId.regionId((String)this.id);
        NetworkConfigService cfgService = RegionAddCommand.get(NetworkConfigService.class);
        BasicRegionConfig cfg = (BasicRegionConfig)cfgService.addConfig((Object)regionId, BasicRegionConfig.class);
        this.setConfigurationData(cfg);
        List<Set<NodeId>> masters = this.parseMasterArgs();
        service.createRegion(regionId, this.name, (Region.Type)REGION_TYPE_MAP.get((Object)this.type), masters);
        this.print("Region successfully added.", new Object[0]);
    }

    private void setConfigurationData(BasicRegionConfig cfg) {
        cfg.name(this.name).locType(this.locType);
        if (GEO.equals(this.locType)) {
            cfg.latitude(this.latOrY).longitude(this.longOrX);
        } else if (GRID.equals(this.locType)) {
            cfg.gridY(this.latOrY).gridX(this.longOrX);
        } else {
            throw new IllegalArgumentException(E_BAD_LOC_TYPE);
        }
        cfg.apply();
    }

    private List<Set<NodeId>> parseMasterArgs() {
        ArrayList masters = Lists.newArrayList();
        HashSet nodeIds = Sets.newHashSet();
        for (String masterArg : this.masterArgs) {
            if (masterArg.equals(SLASH)) {
                masters.add(nodeIds);
                nodeIds = Sets.newHashSet();
                continue;
            }
            nodeIds.add(NodeId.nodeId((String)masterArg));
        }
        masters.add(nodeIds);
        return masters;
    }

    static {
        for (Region.Type t : Region.Type.values()) {
            REGION_TYPE_MAP.put((Object)t.name(), (Object)t);
        }
    }
}

