/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.EthType;
import org.onosproject.cli.net.ExtHeader;
import org.onosproject.cli.net.Icmp6Code;
import org.onosproject.cli.net.Icmp6Type;
import org.onosproject.cli.net.IpProtocol;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketRequest;
import org.onosproject.net.packet.PacketService;

@Command(scope="onos", name="vnet-packet", description="Tests virtual network packet requests")
public class VirtualNetworkPacketRequestCommand
extends AbstractShellCommand {
    @Argument(index=0, name="command", description="Command name (requestPackets|getRequests|cancelPackets)", required=true, multiValued=false)
    private String command = null;
    @Argument(index=1, name="networkId", description="Network ID", required=true, multiValued=false)
    private Long networkId = null;
    @Option(name="--deviceId", description="Device ID", required=false, multiValued=false)
    private String deviceIdString = null;
    @Option(name="-s", aliases={"--ethSrc"}, description="Source MAC Address", required=false, multiValued=false)
    private String srcMacString = null;
    @Option(name="-d", aliases={"--ethDst"}, description="Destination MAC Address", required=false, multiValued=false)
    private String dstMacString = null;
    @Option(name="-t", aliases={"--ethType"}, description="Ethernet Type", required=false, multiValued=false)
    private String ethTypeString = null;
    @Option(name="-v", aliases={"--vlan"}, description="VLAN ID", required=false, multiValued=false)
    private String vlanString = null;
    @Option(name="--ipProto", description="IP Protocol", required=false, multiValued=false)
    private String ipProtoString = null;
    @Option(name="--ipSrc", description="Source IP Prefix", required=false, multiValued=false)
    private String srcIpString = null;
    @Option(name="--ipDst", description="Destination IP Prefix", required=false, multiValued=false)
    private String dstIpString = null;
    @Option(name="--fLabel", description="IPv6 Flow Label", required=false, multiValued=false)
    private String fLabelString = null;
    @Option(name="--icmp6Type", description="ICMPv6 Type", required=false, multiValued=false)
    private String icmp6TypeString = null;
    @Option(name="--icmp6Code", description="ICMPv6 Code", required=false, multiValued=false)
    private String icmp6CodeString = null;
    @Option(name="--ndTarget", description="IPv6 Neighbor Discovery Target Address", required=false, multiValued=false)
    private String ndTargetString = null;
    @Option(name="--ndSLL", description="IPv6 Neighbor Discovery Source Link-Layer", required=false, multiValued=false)
    private String ndSllString = null;
    @Option(name="--ndTLL", description="IPv6 Neighbor Discovery Target Link-Layer", required=false, multiValued=false)
    private String ndTllString = null;
    @Option(name="--tcpSrc", description="Source TCP Port", required=false, multiValued=false)
    private String srcTcpString = null;
    @Option(name="--tcpDst", description="Destination TCP Port", required=false, multiValued=false)
    private String dstTcpString = null;
    @Option(name="--extHdr", description="IPv6 Extension Header Pseudo-field", required=false, multiValued=true)
    private List<String> extHdrStringList = null;

    @Override
    protected void execute() {
        VirtualNetworkService service = VirtualNetworkPacketRequestCommand.get(VirtualNetworkService.class);
        PacketService virtualPacketService = (PacketService)service.get(NetworkId.networkId((long)this.networkId), PacketService.class);
        if (this.command == null) {
            this.print("Command is not defined", new Object[0]);
            return;
        }
        if (this.command.equals("getRequests")) {
            this.getRequests(virtualPacketService);
            return;
        }
        TrafficSelector selector = this.buildTrafficSelector();
        PacketPriority packetPriority = PacketPriority.CONTROL;
        Optional<DeviceId> optionalDeviceId = null;
        if (!Strings.isNullOrEmpty((String)this.deviceIdString)) {
            optionalDeviceId = Optional.of(DeviceId.deviceId((String)this.deviceIdString));
        }
        if (this.command.equals("requestPackets")) {
            if (optionalDeviceId != null) {
                virtualPacketService.requestPackets(selector, packetPriority, this.appId(), optionalDeviceId);
            } else {
                virtualPacketService.requestPackets(selector, packetPriority, this.appId());
            }
            this.print("Virtual packet requested:\n%s", selector);
            return;
        }
        if (this.command.equals("cancelPackets")) {
            if (optionalDeviceId != null) {
                virtualPacketService.cancelPackets(selector, packetPriority, this.appId(), optionalDeviceId);
            } else {
                virtualPacketService.cancelPackets(selector, packetPriority, this.appId());
            }
            this.print("Virtual packet cancelled:\n%s", selector);
            return;
        }
        this.print("Unsupported command %s", this.command);
    }

    private void getRequests(PacketService packetService) {
        List packetRequests = packetService.getRequests();
        if (this.outputJson()) {
            this.print("%s", this.json(packetRequests));
        } else {
            packetRequests.forEach(packetRequest -> this.print(packetRequest.toString(), new Object[0]));
        }
    }

    private JsonNode json(List<PacketRequest> packetRequests) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        packetRequests.forEach(packetRequest -> result.add((JsonNode)this.jsonForEntity(packetRequest, PacketRequest.class)));
        return result;
    }

    private TrafficSelector buildTrafficSelector() {
        IpPrefix srcIpPrefix = null;
        IpPrefix dstIpPrefix = null;
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        if (!Strings.isNullOrEmpty((String)this.srcIpString)) {
            srcIpPrefix = IpPrefix.valueOf((String)this.srcIpString);
            if (srcIpPrefix.isIp4()) {
                selectorBuilder.matchIPSrc(srcIpPrefix);
            } else {
                selectorBuilder.matchIPv6Src(srcIpPrefix);
            }
        }
        if (!Strings.isNullOrEmpty((String)this.dstIpString)) {
            dstIpPrefix = IpPrefix.valueOf((String)this.dstIpString);
            if (dstIpPrefix.isIp4()) {
                selectorBuilder.matchIPDst(dstIpPrefix);
            } else {
                selectorBuilder.matchIPv6Dst(dstIpPrefix);
            }
        }
        if (srcIpPrefix != null && dstIpPrefix != null && srcIpPrefix.version() != dstIpPrefix.version()) {
            throw new IllegalArgumentException("IP source and destination version mismatch");
        }
        Short ethType = null;
        if (srcIpPrefix != null && srcIpPrefix.isIp6()) {
            ethType = EthType.IPV6.value();
        }
        if (dstIpPrefix != null && dstIpPrefix.isIp6()) {
            ethType = EthType.IPV6.value();
        }
        if (!Strings.isNullOrEmpty((String)this.ethTypeString)) {
            ethType = EthType.parseFromString(this.ethTypeString);
        }
        if (ethType != null) {
            selectorBuilder.matchEthType(ethType.shortValue());
        }
        if (!Strings.isNullOrEmpty((String)this.vlanString)) {
            selectorBuilder.matchVlanId(VlanId.vlanId((short)Short.parseShort(this.vlanString)));
        }
        if (!Strings.isNullOrEmpty((String)this.srcMacString)) {
            selectorBuilder.matchEthSrc(MacAddress.valueOf((String)this.srcMacString));
        }
        if (!Strings.isNullOrEmpty((String)this.dstMacString)) {
            selectorBuilder.matchEthDst(MacAddress.valueOf((String)this.dstMacString));
        }
        if (!Strings.isNullOrEmpty((String)this.ipProtoString)) {
            short ipProtoShort = IpProtocol.parseFromString(this.ipProtoString);
            selectorBuilder.matchIPProtocol((byte)ipProtoShort);
        }
        if (!Strings.isNullOrEmpty((String)this.fLabelString)) {
            selectorBuilder.matchIPv6FlowLabel(Integer.parseInt(this.fLabelString));
        }
        if (!Strings.isNullOrEmpty((String)this.icmp6TypeString)) {
            byte icmp6Type = Icmp6Type.parseFromString(this.icmp6TypeString);
            selectorBuilder.matchIcmpv6Type(icmp6Type);
        }
        if (!Strings.isNullOrEmpty((String)this.icmp6CodeString)) {
            byte icmp6Code = Icmp6Code.parseFromString(this.icmp6CodeString);
            selectorBuilder.matchIcmpv6Code(icmp6Code);
        }
        if (!Strings.isNullOrEmpty((String)this.ndTargetString)) {
            selectorBuilder.matchIPv6NDTargetAddress(Ip6Address.valueOf((String)this.ndTargetString));
        }
        if (!Strings.isNullOrEmpty((String)this.ndSllString)) {
            selectorBuilder.matchIPv6NDSourceLinkLayerAddress(MacAddress.valueOf((String)this.ndSllString));
        }
        if (!Strings.isNullOrEmpty((String)this.ndTllString)) {
            selectorBuilder.matchIPv6NDTargetLinkLayerAddress(MacAddress.valueOf((String)this.ndTllString));
        }
        if (!Strings.isNullOrEmpty((String)this.srcTcpString)) {
            selectorBuilder.matchTcpSrc(TpPort.tpPort((int)Integer.parseInt(this.srcTcpString)));
        }
        if (!Strings.isNullOrEmpty((String)this.dstTcpString)) {
            selectorBuilder.matchTcpDst(TpPort.tpPort((int)Integer.parseInt(this.dstTcpString)));
        }
        if (this.extHdrStringList != null) {
            short extHdr = 0;
            for (String extHdrString : this.extHdrStringList) {
                extHdr = (short)(extHdr | ExtHeader.parseFromString(extHdrString));
            }
            selectorBuilder.matchIPv6ExthdrFlags(extHdr);
        }
        return selectorBuilder.build();
    }
}

