/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.cfg;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.Tools;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.SubjectFactory;

@Command(scope="onos", name="netcfg", description="Manages network configuration")
public class NetworkConfigCommand
extends AbstractShellCommand {
    private static final String E_CLASSKEY_NOT_REGISTERED = " is not a registered SubjectClassKey";
    @Argument(index=0, name="subjectClassKey", description="Subject class key", required=false, multiValued=false)
    String subjectClassKey = null;
    @Argument(index=1, name="subjectKey", description="Subject key", required=false, multiValued=false)
    String subjectKey = null;
    @Argument(index=2, name="configKey", description="Config key", required=false, multiValued=false)
    String configKey = null;
    @Option(name="--remove", description="Remove specified configuration tree", required=false)
    private boolean remove = false;
    private final ObjectMapper mapper = new ObjectMapper();
    private NetworkConfigService service;

    @Override
    protected void execute() {
        this.service = NetworkConfigCommand.get(NetworkConfigService.class);
        ObjectNode root = this.mapper.createObjectNode();
        if (Strings.isNullOrEmpty((String)this.subjectClassKey)) {
            if (this.remove) {
                this.service.removeConfig();
            }
            this.addAll(root);
        } else {
            SubjectFactory subjectFactory = (SubjectFactory)Tools.nullIsIllegal((Object)this.service.getSubjectFactory(this.subjectClassKey), (String)(this.subjectClassKey + E_CLASSKEY_NOT_REGISTERED));
            if (Strings.isNullOrEmpty((String)this.subjectKey)) {
                this.addSubjectClass(root, subjectFactory);
            } else {
                Object s = subjectFactory.createSubject(this.subjectKey);
                if (Strings.isNullOrEmpty((String)this.configKey)) {
                    if (this.remove) {
                        this.service.removeConfig(s);
                    }
                    this.addSubject(root, s);
                } else {
                    if (this.remove) {
                        this.service.removeConfig(this.subjectClassKey, s, this.configKey);
                    }
                    root = this.getSubjectConfig(this.getConfig(s, this.subjectClassKey, this.configKey));
                }
            }
        }
        try {
            this.print("%s", this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)root));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error writing JSON to string", e);
        }
    }

    private void addAll(ObjectNode root) {
        this.service.getSubjectClasses().forEach(sc -> {
            SubjectFactory sf = this.service.getSubjectFactory(sc);
            this.addSubjectClass(this.newObject(root, sf.subjectClassKey()), sf);
        });
    }

    private void addSubjectClass(ObjectNode root, SubjectFactory sf) {
        this.service.getSubjects(sf.subjectClass()).forEach(s -> this.addSubject(this.newObject(root, sf.subjectKey(s)), s));
    }

    private void addSubject(ObjectNode root, Object s) {
        this.service.getConfigs(s).forEach(c -> root.set(c.key(), c.node()));
    }

    private JsonNode getSubjectConfig(Config config) {
        return config != null ? config.node() : null;
    }

    private Config getConfig(Object s, String subjectKey, String ck) {
        Class configClass = this.service.getConfigClass(subjectKey, ck);
        return configClass != null ? this.service.getConfig(s, configClass) : null;
    }

    private ObjectNode newObject(ObjectNode parent, String key) {
        ObjectNode node = this.mapper.createObjectNode();
        parent.set(key, (JsonNode)node);
        return node;
    }
}

