/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupService;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="groups", description="Lists all groups in the system")
public class GroupsListCommand
extends AbstractShellCommand {
    public static final String ANY = "any";
    private static final String FORMAT = "   id=0x%s, state=%s, type=%s, bytes=%s, packets=%s, appId=%s, referenceCount=%s";
    private static final String BUCKET_FORMAT = "   id=0x%s, bucket=%s, bytes=%s, packets=%s, actions=%s";
    @Argument(index=1, name="uri", description="Device ID", required=false, multiValued=false)
    String uri = null;
    @Argument(index=0, name="state", description="Group state", required=false, multiValued=false)
    String state;
    @Option(name="-c", aliases={"--count"}, description="Print group count only", required=false, multiValued=false)
    private boolean countOnly = false;
    @Option(name="-t", aliases={"--type"}, description="Print groups with specified type", required=false, multiValued=false)
    private String type = null;

    private JsonNode json(Map<Device, List<Group>> sortedGroups) {
        ArrayNode result = this.mapper().createArrayNode();
        sortedGroups.forEach((device, groups) -> groups.forEach(group -> result.add((JsonNode)this.jsonForEntity(group, Group.class))));
        return result;
    }

    @Override
    protected void execute() {
        DeviceService deviceService = GroupsListCommand.get(DeviceService.class);
        GroupService groupService = GroupsListCommand.get(GroupService.class);
        SortedMap<Device, List<Group>> sortedGroups = this.getSortedGroups(deviceService, groupService);
        if (this.outputJson()) {
            this.print("%s", this.json(sortedGroups));
        } else {
            sortedGroups.forEach((device, groups) -> this.printGroups(device.id(), (List<Group>)groups));
        }
    }

    protected SortedMap<Device, List<Group>> getSortedGroups(DeviceService deviceService, GroupService groupService) {
        Device dev;
        TreeMap<Device, List<Group>> sortedGroups = new TreeMap<Device, List<Group>>(Comparators.ELEMENT_COMPARATOR);
        Group.GroupState s = null;
        if (this.state != null && !ANY.equals(this.state)) {
            s = Group.GroupState.valueOf((String)this.state.toUpperCase());
        }
        List<Device> devices = deviceService.getDevices();
        if (this.uri != null && (dev = deviceService.getDevice(DeviceId.deviceId((String)this.uri))) != null) {
            devices = Collections.singletonList(dev);
        }
        for (Device d : devices) {
            ArrayList groups;
            if (s == null) {
                groups = Lists.newArrayList((Iterable)groupService.getGroups(d.id()));
            } else {
                groups = Lists.newArrayList();
                for (Group g : groupService.getGroups(d.id())) {
                    if (!g.state().equals((Object)s)) continue;
                    groups.add(g);
                }
            }
            groups.sort(Comparators.GROUP_COMPARATOR);
            sortedGroups.put(d, groups);
        }
        if (this.type != null) {
            for (Device device : sortedGroups.keySet()) {
                sortedGroups.put(device, ((List)sortedGroups.get(device)).stream().filter(group -> GroupDescription.Type.valueOf((String)this.type.toUpperCase()).equals((Object)group.type())).collect(Collectors.toList()));
            }
        }
        return sortedGroups;
    }

    private void printGroups(DeviceId deviceId, List<Group> groups) {
        this.print("deviceId=%s, groupCount=%s", deviceId, groups.size());
        if (this.countOnly) {
            return;
        }
        for (Group group : groups) {
            this.print(FORMAT, Integer.toHexString((Integer)group.id().id()), group.state(), group.type(), group.bytes(), group.packets(), group.appId().name(), group.referenceCount());
            int i = 0;
            for (GroupBucket bucket : group.buckets().buckets()) {
                this.print(BUCKET_FORMAT, Integer.toHexString((Integer)group.id().id()), ++i, bucket.bytes(), bucket.packets(), bucket.treatment().allInstructions());
            }
        }
    }
}

