/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.routing.ResolvedRoute;
import org.onosproject.incubator.net.routing.RouteInfo;
import org.onosproject.incubator.net.routing.RouteService;
import org.onosproject.incubator.net.routing.RouteTableId;

@Command(scope="onos", name="routes", description="Lists routes in the route store")
public class RoutesListCommand
extends AbstractShellCommand {
    private static final String NETWORK = "Network";
    private static final String NEXTHOP = "Next Hop";
    private static final String SOURCE = "Source";
    private static final String NODE = "Node";
    private static final String FORMAT_ROUTE = "%-1s   %-18s %-15s %s (%s)";
    private static final String FORMAT_ROUTE6 = "%-1s   %-43s %-39s %s (%s)";
    private static final String FORMAT_TABLE = "Table: %s";
    private static final String FORMAT_TOTAL = "   Total: %d";

    @Override
    protected void execute() {
        RouteService service = AbstractShellCommand.get(RouteService.class);
        if (this.outputJson()) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode result = mapper.createObjectNode();
            result.set("routes4", this.json(service.getRoutes(new RouteTableId("ipv4"))));
            result.set("routes6", this.json(service.getRoutes(new RouteTableId("ipv6"))));
            this.print("%s", result);
        } else {
            service.getRouteTables().forEach(id -> {
                Collection tableRoutes = service.getRoutes(id);
                String format = tableRoutes.stream().anyMatch(route -> route.prefix().isIp6()) ? FORMAT_ROUTE6 : FORMAT_ROUTE;
                this.print(FORMAT_TABLE, id);
                this.print(format, "", NETWORK, NEXTHOP, SOURCE, NODE);
                tableRoutes.stream().sorted(Comparator.comparing(r -> r.prefix().address())).forEach(route -> this.print(format, (RouteInfo)route));
                this.print(FORMAT_TOTAL, tableRoutes.size());
                this.print("", new Object[0]);
            });
        }
    }

    private void print(String format, RouteInfo routeInfo) {
        routeInfo.allRoutes().stream().sorted(Comparator.comparing(r -> r.nextHop())).forEach(r -> this.print(format, this.isBestRoute(routeInfo.bestRoute(), (ResolvedRoute)r) ? ">" : "", r.prefix(), r.nextHop(), r.route().source(), r.route().sourceNode()));
    }

    private boolean isBestRoute(Optional<ResolvedRoute> bestRoute, ResolvedRoute route) {
        return Objects.equals(bestRoute.orElse(null), route);
    }

    private JsonNode json(Collection<RouteInfo> routes) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        routes.stream().flatMap(ri -> ri.allRoutes().stream()).forEach(r -> result.add((JsonNode)this.json(mapper, (ResolvedRoute)r)));
        return result;
    }

    private ObjectNode json(ObjectMapper mapper, ResolvedRoute route) {
        ObjectNode result = mapper.createObjectNode();
        result.put("prefix", route.prefix().toString());
        result.put("nextHop", route.nextHop().toString());
        return result;
    }
}

