/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Optional;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicLinkConfig;
import org.onosproject.net.device.DeviceService;

@Command(scope="onos", name="config-link", description="Configure link.")
public class ConfigureLinkCommand
extends AbstractShellCommand {
    @Argument(index=0, name="src", description="src port", required=true, multiValued=false)
    String src = null;
    @Argument(index=1, name="dst", description="dst port", required=true, multiValued=false)
    String dst = null;
    @Option(name="--type", description="specify link type", valueToShowInHelp="DIRECT")
    String type = Link.Type.DIRECT.name();
    @Option(name="--uni-directional", description="specify that link is uni-directional")
    boolean isUniDi = false;
    @Option(name="--bandwidth", description="bandwidth in Mbps (integer)")
    String bandwidth = null;
    @Option(name="--disallow", description="disallow link")
    boolean disallow = false;
    @Option(name="--remove-config", description="remove link configuration")
    boolean remove = false;

    @Override
    protected void execute() {
        DeviceService deviceService = ConfigureLinkCommand.get(DeviceService.class);
        NetworkConfigService netCfgService = ConfigureLinkCommand.get(NetworkConfigService.class);
        ConnectPoint srcCp = ConnectPoint.deviceConnectPoint((String)this.src);
        if (deviceService.getPort(srcCp) == null) {
            this.print("[ERROR] %s does not exist", srcCp);
            return;
        }
        ConnectPoint dstCp = ConnectPoint.deviceConnectPoint((String)this.dst);
        if (deviceService.getPort(dstCp) == null) {
            this.print("[ERROR] %s does not exist", dstCp);
            return;
        }
        LinkKey link = LinkKey.linkKey((ConnectPoint)srcCp, (ConnectPoint)dstCp);
        if (this.remove) {
            netCfgService.removeConfig((Object)link, BasicLinkConfig.class);
            return;
        }
        Long bw = Optional.ofNullable(this.bandwidth).map(Long::valueOf).orElse(null);
        Link.Type linkType = Link.Type.valueOf((String)this.type);
        BasicLinkConfig cfg = (BasicLinkConfig)netCfgService.addConfig((Object)link, BasicLinkConfig.class);
        cfg.isAllowed(Boolean.valueOf(!this.disallow));
        cfg.isBidirectional(Boolean.valueOf(!this.isUniDi));
        cfg.type(linkType);
        if (bw != null) {
            cfg.bandwidth(bw);
        }
        cfg.apply();
    }
}

