/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Ordering;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.primitives.PartitionAdminService;
import org.onosproject.store.service.PartitionClientInfo;
import org.onosproject.store.service.PartitionInfo;
import org.onosproject.store.service.StorageAdminService;

@Command(scope="onos", name="partitions", description="Lists information about partitions in the system")
public class PartitionsListCommand
extends AbstractShellCommand {
    @Option(name="-c", aliases={"--clients"}, description="Show information about partition clients", required=false, multiValued=false)
    private boolean reportClientInfo = false;
    private static final String SERVER_FMT = "%-20s %8s %25s %s";
    private static final String CLIENT_FMT = "%-20s %8s";

    private void displayPartitions(List<PartitionInfo> partitionInfo) {
        if (partitionInfo.isEmpty()) {
            return;
        }
        this.print("----------------------------------------------------------", new Object[0]);
        this.print(SERVER_FMT, "Name", "Term", "Members", "");
        this.print("----------------------------------------------------------", new Object[0]);
        for (PartitionInfo info : partitionInfo) {
            boolean first = true;
            for (String member : Ordering.natural().sortedCopy((Iterable)info.members())) {
                if (first) {
                    this.print(SERVER_FMT, info.name(), info.term(), member, member.equals(info.leader()) ? "*" : "");
                    first = false;
                    continue;
                }
                this.print(SERVER_FMT, "", "", member, member.equals(info.leader()) ? "*" : "");
            }
            if (first) continue;
            this.print("----------------------------------------------------------", new Object[0]);
        }
    }

    private void displayPartitionClients(List<PartitionClientInfo> partitionClientInfo) {
        if (partitionClientInfo.isEmpty()) {
            return;
        }
        ClusterService clusterService = PartitionsListCommand.get(ClusterService.class);
        this.print("-------------------------------------------------------------------", new Object[0]);
        this.print(CLIENT_FMT, "Name", "Servers");
        this.print("-------------------------------------------------------------------", new Object[0]);
        for (PartitionClientInfo info : partitionClientInfo) {
            boolean first = true;
            for (NodeId serverId : Ordering.natural().sortedCopy((Iterable)info.servers())) {
                ControllerNode server = clusterService.getNode(serverId);
                String serverString = String.format("%s:%d", server.id(), server.tcpPort());
                if (first) {
                    this.print(CLIENT_FMT, info.partitionId(), serverString);
                    first = false;
                    continue;
                }
                this.print(CLIENT_FMT, "", serverString);
            }
            if (first) continue;
            this.print("-------------------------------------------------------------------", new Object[0]);
        }
    }

    private JsonNode json(List<PartitionInfo> partitionInfo) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode partitions = mapper.createArrayNode();
        partitionInfo.forEach(info -> {
            ObjectNode partition = mapper.createObjectNode();
            ArrayNode members = partition.putArray("members");
            info.members().forEach(arg_0 -> ((ArrayNode)members).add(arg_0));
            partition.put("name", info.name()).put("term", info.term()).put("leader", info.leader());
            partitions.add((JsonNode)partition);
        });
        return partitions;
    }

    private JsonNode jsonForClientInfo(List<PartitionClientInfo> partitionClientInfo) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode partitions = mapper.createArrayNode();
        ClusterService clusterService = PartitionsListCommand.get(ClusterService.class);
        partitionClientInfo.forEach(info -> {
            ObjectNode partition = mapper.createObjectNode();
            ArrayNode servers = partition.putArray("servers");
            info.servers().stream().map(arg_0 -> ((ClusterService)clusterService).getNode(arg_0)).map(node -> String.format("%s:%d", node.ip(), node.tcpPort())).forEach(arg_0 -> ((ArrayNode)servers).add(arg_0));
            partition.put("partitionId", info.partitionId().toString());
            partitions.add((JsonNode)partition);
        });
        return partitions;
    }

    @Override
    protected void execute() {
        StorageAdminService storageAdminService = PartitionsListCommand.get(StorageAdminService.class);
        if (this.reportClientInfo) {
            PartitionAdminService partitionAdminService = PartitionsListCommand.get(PartitionAdminService.class);
            List partitionClientInfo = partitionAdminService.partitionClientInfo();
            if (this.outputJson()) {
                this.print("%s", this.jsonForClientInfo(partitionClientInfo));
            } else {
                this.displayPartitionClients(partitionClientInfo);
            }
        } else {
            List partitionInfo = storageAdminService.getPartitionInfo();
            if (this.outputJson()) {
                this.print("%s", this.json(partitionInfo));
            } else {
                this.displayPartitions(partitionInfo);
            }
        }
    }
}

