/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DevicesListCommand;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;

@Command(scope="onos", name="roles", description="Lists mastership roles of nodes for each device.")
public class RolesCommand
extends AbstractShellCommand {
    private static final String FMT_HDR = "%s: master=%s, standbys=[ %s]";

    @Override
    protected void execute() {
        DeviceService deviceService = RolesCommand.get(DeviceService.class);
        MastershipService roleService = RolesCommand.get(MastershipService.class);
        if (this.outputJson()) {
            this.print("%s", this.json(roleService, DevicesListCommand.getSortedDevices(deviceService)));
        } else {
            for (Device d : DevicesListCommand.getSortedDevices(deviceService)) {
                DeviceId did = d.id();
                this.printRoles(roleService, did);
            }
        }
    }

    private JsonNode json(MastershipService service, List<Device> sortedDevices) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode results = mapper.createArrayNode();
        for (Device device : sortedDevices) {
            results.add(this.json(service, mapper, device));
        }
        return results;
    }

    private JsonNode json(MastershipService service, ObjectMapper mapper, Device device) {
        NodeId master = service.getMasterFor(device.id());
        ObjectNode result = mapper.createObjectNode().put("id", device.id().toString()).put("master", master != null ? master.toString() : "none");
        RoleInfo nodes = service.getNodesFor(device.id());
        ArrayNode standbys = mapper.createArrayNode();
        for (NodeId nid : nodes.backups()) {
            standbys.add(nid.toString());
        }
        result.set("standbys", (JsonNode)standbys);
        return result;
    }

    protected void printRoles(MastershipService service, DeviceId deviceId) {
        RoleInfo nodes = service.getNodesFor(deviceId);
        StringBuilder builder = new StringBuilder();
        for (NodeId nid : nodes.backups()) {
            builder.append(nid).append(" ");
        }
        this.print(FMT_HDR, deviceId, nodes.master() == null ? "NONE" : nodes.master(), builder.toString());
    }
}

