/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.util.concurrent.Futures;
import java.util.concurrent.Future;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;

@Command(scope="onos", name="device-role", description="Sets role of the controller node for the given infrastructure device")
public class DeviceRoleCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    String uri = null;
    @Argument(index=1, name="node", description="Node ID", required=true, multiValued=false)
    String node = null;
    @Argument(index=2, name="role", description="Mastership role", required=true, multiValued=false)
    String role = null;

    @Override
    protected void execute() {
        MastershipAdminService service = DeviceRoleCommand.get(MastershipAdminService.class);
        MastershipRole mastershipRole = MastershipRole.valueOf((String)this.role.toUpperCase());
        Futures.getUnchecked((Future)service.setRole(new NodeId(this.node), DeviceId.deviceId((String)this.uri), mastershipRole));
    }
}

