/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.Tools;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;

@Command(scope="onos", name="leaders", description="Finds the leader for particular topic.")
public class LeaderCommand
extends AbstractShellCommand {
    private static final String FMT = "%-30s | %-15s | %-5s | %-10s |";
    private static final String FMT_C = "%-30s | %-15s | %-5s | %-10s | %-19s |";
    private boolean allTopics;
    private Pattern pattern;
    @Argument(index=0, name="topic", description="A leadership topic. Can be a regex", required=false, multiValued=false)
    String topicPattern = null;
    @Option(name="-c", aliases={"--candidates"}, description="List candidate Nodes for each topic's leadership race", required=false, multiValued=false)
    private boolean showCandidates = false;
    private Comparator<Leadership> leadershipComparator = (l1, l2) -> String.valueOf(l1.leaderNodeId()).compareTo(String.valueOf(l2.leaderNodeId()));

    private void displayLeaders(Map<String, Leadership> leaderBoard) {
        this.print("------------------------------------------------------------------------", new Object[0]);
        this.print(FMT, "Topic", "Leader", "Term", "Elected");
        this.print("------------------------------------------------------------------------", new Object[0]);
        leaderBoard.values().stream().filter(l -> this.allTopics || this.pattern.matcher(l.topic()).matches()).filter(l -> l.leader() != null).sorted(this.leadershipComparator).forEach(l -> this.print(FMT, l.topic(), l.leaderNodeId(), l.leader().term(), Tools.timeAgo((long)l.leader().termStartTime())));
        this.print("------------------------------------------------------------------------", new Object[0]);
    }

    private void displayCandidates(Map<String, Leadership> leaderBoard) {
        this.print("--------------------------------------------------------------------------------------------", new Object[0]);
        this.print(FMT_C, "Topic", "Leader", "Term", "Elected", "Candidates");
        this.print("--------------------------------------------------------------------------------------------", new Object[0]);
        leaderBoard.entrySet().stream().filter(es -> this.allTopics || this.pattern.matcher((CharSequence)es.getKey()).matches()).sorted((a, b) -> this.leadershipComparator.compare((Leadership)a.getValue(), (Leadership)b.getValue())).forEach(es -> {
            Leadership l = (Leadership)es.getValue();
            List candidateList = l.candidates();
            if (candidateList == null || candidateList.isEmpty()) {
                return;
            }
            this.print(FMT_C, es.getKey(), String.valueOf(l.leaderNodeId()), l.leader().term(), Tools.timeAgo((long)l.leader().termStartTime()), ((NodeId)candidateList.get(0)).toString());
            candidateList.subList(1, candidateList.size()).forEach(n -> this.print(FMT_C, " ", " ", " ", " ", n));
            this.print(FMT_C, " ", " ", " ", " ", " ");
        });
        this.print("--------------------------------------------------------------------------------------------", new Object[0]);
    }

    private JsonNode json(Map<String, Leadership> leaderBoard) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        leaderBoard.forEach((topic, leadership) -> result.add((JsonNode)mapper.createObjectNode().put("topic", topic).put("leader", leadership.leaderNodeId() == null ? "none" : leadership.leaderNodeId().toString()).put("term", leadership.leader() != null ? leadership.leader().term() : 0L).put("termStartTime", leadership.leader() != null ? leadership.leader().termStartTime() : 0L).put("candidates", leadership.candidates().toString())));
        return result;
    }

    @Override
    protected void execute() {
        LeadershipService leaderService = LeaderCommand.get(LeadershipService.class);
        Map leaderBoard = leaderService.getLeaderBoard();
        if (this.topicPattern == null) {
            this.allTopics = true;
        } else {
            this.allTopics = false;
            this.pattern = Pattern.compile(this.topicPattern);
        }
        if (this.outputJson()) {
            this.print("%s", this.json(leaderBoard));
            return;
        }
        if (this.showCandidates) {
            this.displayCandidates(leaderBoard);
        } else {
            this.displayLeaders(leaderBoard);
        }
    }
}

