/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Collections;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.DefaultMeterRequest;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterRequest;
import org.onosproject.net.meter.MeterService;

@Command(scope="onos", name="meter-remove", description="Removes a meter from a device (currently for testing)")
public class MeterRemoveCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    private String uri = null;
    @Argument(index=1, name="meterId", description="Meter ID hexadecimal value", required=true, multiValued=false)
    private String meterIdstr = null;
    private final String appId = "org.onosproject.cli.meterCmd";

    @Override
    protected void execute() {
        MeterService service = MeterRemoveCommand.get(MeterService.class);
        CoreService coreService = MeterRemoveCommand.get(CoreService.class);
        DeviceId deviceId = DeviceId.deviceId((String)this.uri);
        MeterId meterId = MeterId.meterId((long)Long.parseLong(this.meterIdstr, 16));
        DefaultBand b = new DefaultBand(Band.Type.DROP, 0L, Long.valueOf(0L), Short.valueOf((short)0));
        MeterRequest.Builder builder = DefaultMeterRequest.builder().forDevice(deviceId).withBands(Collections.singleton(b)).withUnit(Meter.Unit.PKTS_PER_SEC).fromApp(coreService.registerApplication("org.onosproject.cli.meterCmd"));
        MeterRequest meterRequest = builder.remove();
        service.withdraw(meterRequest, meterId);
        this.log.info("Requested meter removal: {}", (Object)meterRequest.toString());
        this.print("Requested meter removal: %s", meterRequest.toString());
    }
}

