/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.cli.AbstractChoicesCompleter;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.utils.Comparators;

public class VirtualDeviceCompleter
extends AbstractChoicesCompleter {
    @Override
    protected List<String> choices() {
        String[] argsArray;
        ArgumentCompleter.ArgumentList args = this.getArgumentList();
        for (String str : argsArray = args.getArguments()) {
            if (!str.matches("[0-9]+")) continue;
            long networkId = Long.valueOf(str);
            return this.getSortedVirtualDevices(networkId).stream().map(virtualDevice -> virtualDevice.id().toString()).collect(Collectors.toList());
        }
        return Collections.singletonList("Missing network id");
    }

    private List<VirtualDevice> getSortedVirtualDevices(long networkId) {
        VirtualNetworkService service = (VirtualNetworkService)DefaultServiceDirectory.getService(VirtualNetworkService.class);
        ArrayList<VirtualDevice> virtualDevices = new ArrayList<VirtualDevice>();
        virtualDevices.addAll(service.getVirtualDevices(NetworkId.networkId((long)networkId)));
        Collections.sort(virtualDevices, Comparators.VIRTUAL_DEVICE_COMPARATOR);
        return virtualDevices;
    }
}

