/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.ArrayList;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.VlanId;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.InterfaceConfig;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="device-add-interface", description="Configures a device interface")
public class DeviceInterfaceAddCommand
extends AbstractShellCommand {
    private static final String ONE_ACTION_ALLOWED = "One configuration action allowed at a time";
    private static final String CONFIG_VLAN_SUCCESS = "VLAN %s added on device %s interface %s.";
    private static final String CONFIG_VLAN_FAILURE = "Failed to add VLAN %s on device %s interface %s.";
    private static final String CONFIG_TRUNK_SUCCESS = "Trunk mode added for VLAN %s on device %s interface %s.";
    private static final String CONFIG_TRUNK_FAILURE = "Failed to add trunk mode for VLAN %s on device %s interface %s.";
    private static final String CONFIG_RATE_SUCCESS = "Rate limit %d%% added on device %s interface %s.";
    private static final String CONFIG_RATE_FAILURE = "Failed to add rate limit %d%% on device %s interface %s.";
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    private String uri = null;
    @Argument(index=1, name="interface", description="Interface name", required=true, multiValued=false)
    private String portName = null;
    @Option(name="-r", aliases={"--rate-limit"}, description="Percentage for egress bandwidth limit", required=false, multiValued=false)
    private String limitString = null;
    @Option(name="-t", aliases={"--trunk"}, description="VLAN(s) for trunk port (multiple values are allowed)", required=false, multiValued=true)
    private String[] trunkVlanStrings = null;
    @Option(name="-a", aliases={"--access"}, description="VLAN for access port", required=false, multiValued=false)
    private String accessVlanString = null;

    @Override
    protected void execute() {
        DriverService service = DeviceInterfaceAddCommand.get(DriverService.class);
        DeviceId deviceId = DeviceId.deviceId((String)this.uri);
        DriverHandler h = service.createHandler(deviceId, new String[0]);
        InterfaceConfig interfaceConfig = (InterfaceConfig)h.behaviour(InterfaceConfig.class);
        if (this.accessVlanString != null && this.trunkVlanStrings == null && this.limitString == null) {
            this.addAccessModeToIntf(interfaceConfig);
        } else if (this.trunkVlanStrings != null && this.accessVlanString == null && this.limitString == null) {
            this.addTrunkModeToIntf(interfaceConfig);
        } else if (this.limitString != null && this.accessVlanString == null && this.trunkVlanStrings == null) {
            this.addRateLimitToIntf(interfaceConfig);
        } else {
            this.print(ONE_ACTION_ALLOWED, new Object[0]);
        }
    }

    private void addRateLimitToIntf(InterfaceConfig config) {
        short rate = Short.parseShort(this.limitString);
        if (config.addRateLimit(this.portName, rate)) {
            this.print(CONFIG_RATE_SUCCESS, rate, this.uri, this.portName);
        } else {
            this.print(CONFIG_RATE_FAILURE, rate, this.uri, this.portName);
        }
    }

    private void addTrunkModeToIntf(InterfaceConfig config) {
        ArrayList<VlanId> vlanIds = new ArrayList<VlanId>();
        for (String vlanString : this.trunkVlanStrings) {
            vlanIds.add(VlanId.vlanId((short)Short.parseShort(vlanString)));
        }
        if (config.addTrunkMode(this.portName, vlanIds)) {
            this.print(CONFIG_TRUNK_SUCCESS, vlanIds, this.uri, this.portName);
        } else {
            this.print(CONFIG_TRUNK_FAILURE, vlanIds, this.uri, this.portName);
        }
    }

    private void addAccessModeToIntf(InterfaceConfig config) {
        VlanId accessVlanId = VlanId.vlanId((short)Short.parseShort(this.accessVlanString));
        if (config.addAccessMode(this.portName, accessVlanId)) {
            this.print(CONFIG_VLAN_SUCCESS, accessVlanId, this.uri, this.portName);
        } else {
            this.print(CONFIG_VLAN_FAILURE, accessVlanId, this.uri, this.portName);
        }
    }
}

