/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.TributarySlot;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceQueryService;
import org.onosproject.net.resource.Resources;

@Command(scope="onos", name="resources", description="Lists registered resources")
public class ResourcesCommand
extends AbstractShellCommand {
    @Option(name="-a", aliases={"--available"}, description="Output available resources only", required=false, multiValued=false)
    boolean availablesOnly = false;
    @Option(name="-s", aliases={"--sort"}, description="Sort output", required=false, multiValued=false)
    boolean sort = false;
    @Option(name="-t", aliases={"--typeStrings"}, description="List of resource types to be printed", required=false, multiValued=true)
    String[] typeStrings = null;
    Set<String> typesToPrint;
    @Argument(index=0, name="deviceIdString", description="Device ID", required=false, multiValued=false)
    String deviceIdStr = null;
    @Argument(index=1, name="portNumberString", description="PortNumber", required=false, multiValued=false)
    String portNumberStr = null;
    private ResourceQueryService resourceService;

    @Override
    protected void execute() {
        this.resourceService = ResourcesCommand.get(ResourceQueryService.class);
        this.typesToPrint = this.typeStrings != null ? new HashSet<String>(Arrays.asList(this.typeStrings)) : Collections.emptySet();
        if (this.deviceIdStr != null && this.portNumberStr != null) {
            DeviceId deviceId = DeviceId.deviceId((String)this.deviceIdStr);
            PortNumber portNumber = PortNumber.fromString((String)this.portNumberStr);
            this.printResource((Resource)Resources.discrete((DeviceId)deviceId, (PortNumber)portNumber, (Object[])new Object[0]).resource(), 0);
        } else if (this.deviceIdStr != null) {
            DeviceId deviceId = DeviceId.deviceId((String)this.deviceIdStr);
            this.printResource((Resource)Resources.discrete((DeviceId)deviceId).resource(), 0);
        } else {
            this.printResource((Resource)Resource.ROOT, 0);
        }
    }

    private void printResource(Resource resource, int level) {
        Set children = resource instanceof DiscreteResource ? this.resourceService.getRegisteredResources(((DiscreteResource)resource).id()) : Collections.emptySet();
        if (resource.equals(Resource.ROOT)) {
            this.print("ROOT", new Object[0]);
        } else {
            String toString;
            String resourceName = resource.simpleTypeName();
            if (resource instanceof ContinuousResource) {
                if (this.availablesOnly) {
                    double total = ((ContinuousResource)resource).value();
                    double allocated = this.resourceService.getResourceAllocations(resource.id()).stream().mapToDouble(rA -> ((ContinuousResource)rA.resource()).value()).sum();
                    double difference = total - allocated;
                    this.print("%s%s: %f", Strings.repeat((String)" ", (int)level), resourceName, difference);
                } else {
                    this.print("%s%s: %f", Strings.repeat((String)" ", (int)level), resourceName, ((ContinuousResource)resource).value());
                }
                return;
            }
            String availability = "";
            if (this.availablesOnly && !children.isEmpty()) {
                availability = this.resourceService.isAvailable(resource) ? " \u2714" : " \u2718";
            }
            if ((toString = String.valueOf(resource.valueAs(Object.class).orElse(""))).startsWith(resourceName)) {
                this.print("%s%s%s", Strings.repeat((String)" ", (int)level), toString, availability);
            } else {
                this.print("%s%s: %s%s", Strings.repeat((String)" ", (int)level), resourceName, toString, availability);
            }
        }
        ImmutableSet aggregatableTypes = ImmutableSet.builder().add(VlanId.class).add(MplsLabel.class).build();
        ArrayListMultimap aggregatables = ArrayListMultimap.create();
        ArrayList<Resource> nonAggregatable = new ArrayList<Resource>();
        for (Resource r2 : children) {
            if (!this.isPrintTarget(r2)) continue;
            if (r2 instanceof ContinuousResource) {
                nonAggregatable.add(r2);
                continue;
            }
            if (Iterables.any((Iterable)aggregatableTypes, arg_0 -> ((Resource)r2).isTypeOf(arg_0))) {
                String simpleName = r2.simpleTypeName();
                aggregatables.put((Object)simpleName, (Object)r2);
                continue;
            }
            nonAggregatable.add(r2);
        }
        aggregatables.asMap().entrySet().forEach(e -> {
            String resourceName = (String)e.getKey();
            TreeRangeSet rangeSet = TreeRangeSet.create();
            ((Collection)e.getValue()).stream().map(res -> {
                if (res.isTypeOf(VlanId.class)) {
                    return ((VlanId)res.valueAs(VlanId.class).get()).toShort();
                }
                if (res.isTypeOf(MplsLabel.class)) {
                    return ((MplsLabel)res.valueAs(MplsLabel.class).get()).toInt();
                }
                if (res.isTypeOf(TributarySlot.class)) {
                    return ((TributarySlot)res.valueAs(TributarySlot.class).get()).index();
                }
                return 0L;
            }).map(Range::singleton).map(range -> range.canonical(DiscreteDomain.longs())).forEach(arg_0 -> ((RangeSet)rangeSet).add(arg_0));
            this.print("%s%s: %s", Strings.repeat((String)" ", (int)(level + 1)), resourceName, rangeSet);
        });
        if (this.sort) {
            nonAggregatable.stream().sorted((o1, o2) -> String.valueOf(o1.id()).compareTo(String.valueOf(o2.id()))).forEach(r -> this.printResource((Resource)r, level + 1));
        } else {
            nonAggregatable.forEach(r -> this.printResource((Resource)r, level + 1));
        }
    }

    private boolean isPrintTarget(Resource resource) {
        if (this.typesToPrint.isEmpty()) {
            return true;
        }
        String resourceName = resource.simpleTypeName();
        if (resource instanceof DiscreteResource) {
            if (!this.resourceService.getRegisteredResources(((DiscreteResource)resource).id()).isEmpty()) {
                return true;
            }
            if (this.availablesOnly && !this.resourceService.isAvailable(resource)) {
                return false;
            }
        } else if (!(resource instanceof ContinuousResource)) {
            this.log.warn("Unexpected resource class: {}", (Object)resource.getClass().getSimpleName());
            return false;
        }
        return this.typesToPrint.contains(resourceName);
    }
}

