/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiExtensionService;

@Command(scope="onos", name="ui-views", description="Lists all registered UI views")
public class UiViewListCommand
extends AbstractShellCommand {
    private static final String FMT = "id=%s, category=%s, label=%s, icon=%s";

    @Override
    protected void execute() {
        UiExtensionService service = UiViewListCommand.get(UiExtensionService.class);
        if (this.outputJson()) {
            this.print("%s", this.json(service.getExtensions()));
        } else {
            service.getExtensions().forEach(ext -> ext.views().forEach(v -> this.print(FMT, v.id(), v.category(), v.label(), v.iconId())));
        }
    }

    private JsonNode json(List<UiExtension> extensions) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode node = mapper.createArrayNode();
        extensions.forEach(ext -> ext.views().forEach(v -> node.add((JsonNode)mapper.createObjectNode().put("id", v.id()).put("category", v.category().toString()).put("label", v.label()).put("icon", v.iconId()))));
        return node;
    }
}

