/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.app;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.onosproject.app.ApplicationService;
import org.onosproject.app.ApplicationState;
import org.onosproject.cli.AbstractCompleter;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.Application;

public class ApplicationNameCompleter
extends AbstractCompleter {
    public int complete(String buffer, int cursor, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        ArgumentCompleter.ArgumentList list = this.getArgumentList();
        String cmd = list.getArguments()[1];
        ApplicationService service = AbstractShellCommand.get(ApplicationService.class);
        Iterator it = service.getApplications().iterator();
        SortedSet strings = delegate.getStrings();
        while (it.hasNext()) {
            Application app = (Application)it.next();
            ApplicationState state = service.getState(app.id());
            if (!"uninstall".equals(cmd) && !"download".equals(cmd) && (!"activate".equals(cmd) || state != ApplicationState.INSTALLED) && (!"deactivate".equals(cmd) || state != ApplicationState.ACTIVE)) continue;
            strings.add(app.id().name());
        }
        if (!Strings.isNullOrEmpty((String)buffer)) {
            List suffixCandidates = strings.stream().map(full -> full.replaceFirst("org\\.onosproject\\.", "")).flatMap(appName -> {
                ArrayList suffixes = new ArrayList();
                ArrayDeque frags = new ArrayDeque();
                Lists.reverse(Arrays.asList(appName.split("\\."))).forEach(frag -> {
                    frags.addFirst(frag);
                    suffixes.add(frags.stream().collect(Collectors.joining(".")));
                });
                return suffixes.stream();
            }).collect(Collectors.groupingBy(e -> e, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() == 1L).map(Map.Entry::getKey).collect(Collectors.toList());
            delegate.getStrings().addAll(suffixCandidates);
        }
        return delegate.complete(buffer, cursor, candidates);
    }
}

