/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.ControllerConfig;
import org.onosproject.net.behaviour.ControllerInfo;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="device-setcontrollers", description="sets the list of controllers for the given infrastructure device")
public class DeviceSetControllersCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    String uri = null;
    @Argument(index=1, name="controllersListStrings", description="list of controllers to set for the specified device", required=true, multiValued=true)
    String[] controllersListStrings = null;
    private DeviceId deviceId;
    private List<ControllerInfo> newControllers = new ArrayList<ControllerInfo>();

    @Override
    protected void execute() {
        Arrays.asList(this.controllersListStrings).forEach(cInfoString -> this.newControllers.add(this.parseCInfoString((String)cInfoString)));
        DriverService service = DeviceSetControllersCommand.get(DriverService.class);
        this.deviceId = DeviceId.deviceId((String)this.uri);
        DriverHandler h = service.createHandler(this.deviceId, new String[0]);
        ControllerConfig config = (ControllerConfig)h.behaviour(ControllerConfig.class);
        this.print("before:", new Object[0]);
        config.getControllers().forEach(c -> this.print(c.target(), new Object[0]));
        try {
            config.setControllers(this.newControllers);
        }
        catch (NullPointerException e) {
            this.print("No Device with requested parameters {} ", this.uri);
        }
        this.print("after:", new Object[0]);
        config.getControllers().forEach(c -> this.print(c.target(), new Object[0]));
        this.print("size %d", config.getControllers().size());
    }

    private ControllerInfo parseCInfoString(String cInfoString) {
        String[] config = cInfoString.split(",");
        if (config.length == 2) {
            String[] pair = config[1].split("=");
            if (pair.length != 2) {
                this.print("Wrong format {}", config[1]);
                return null;
            }
            DefaultAnnotations annotation = DefaultAnnotations.builder().set(pair[0], pair[1]).build();
            String[] data = config[0].split(":");
            String type = data[0];
            IpAddress ip = IpAddress.valueOf((String)data[1]);
            int port = Integer.parseInt(data[2]);
            return new ControllerInfo(ip, port, type, (Annotations)annotation);
        }
        this.print(config[0], new Object[0]);
        return new ControllerInfo(config[0]);
    }
}

