/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterService;

@Command(scope="onos", name="meters", description="Shows meters")
public class MetersListCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    String uri = null;
    @Argument(index=1, name="meter", description="Meter ID", required=false, multiValued=false)
    String meterstr = null;
    MeterId meterId = null;

    @Override
    protected void execute() {
        if (!Strings.isNullOrEmpty((String)this.meterstr)) {
            this.meterId = MeterId.meterId((long)Long.parseLong(this.meterstr));
        }
        MeterService service = MetersListCommand.get(MeterService.class);
        if (this.meterId != null && this.uri != null) {
            Meter m2 = service.getMeter(DeviceId.deviceId((String)this.uri), this.meterId);
            if (m2 != null) {
                this.print("%s", m2);
            } else {
                this.error("Meter %s not found for device %s", this.meterId, this.uri);
            }
        } else {
            Collection meters = service.getAllMeters();
            if (this.uri == null) {
                this.printMeters(meters);
            } else {
                this.printMeters(Collections2.filter((Collection)meters, m -> m.deviceId().equals((Object)DeviceId.deviceId((String)this.uri))));
            }
        }
    }

    private void printMeters(Collection<Meter> meters) {
        meters.forEach(m -> this.print(" %s", m));
    }
}

