/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.TenantId;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.utils.Comparators;

@Command(scope="onos", name="vnet-tenants", description="Lists all virtual network tenants.")
public class TenantListCommand
extends AbstractShellCommand {
    private static final String FMT_TENANT = "tenantId=%s";

    @Override
    protected void execute() {
        VirtualNetworkAdminService service = TenantListCommand.get(VirtualNetworkAdminService.class);
        ArrayList tenants = new ArrayList();
        tenants.addAll(service.getTenantIds());
        Collections.sort(tenants, Comparators.TENANT_ID_COMPARATOR);
        tenants.forEach(this::printTenant);
    }

    private void printTenant(TenantId tenantId) {
        this.print(FMT_TENANT, tenantId.id());
    }
}

