/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualLink;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;

@Command(scope="onos", name="vnet-links", description="Lists all virtual links in a virtual network.")
public class VirtualLinkListCommand
extends AbstractShellCommand {
    private static final String FMT_VIRTUAL_LINK = "src=%s, dst=%s, state=%s, tunnelId=%s";
    @Argument(index=0, name="networkId", description="Network ID", required=true, multiValued=false)
    Long networkId = null;

    @Override
    protected void execute() {
        this.getSortedVirtualLinks().forEach(this::printVirtualLink);
    }

    private List<VirtualLink> getSortedVirtualLinks() {
        VirtualNetworkService service = VirtualLinkListCommand.get(VirtualNetworkService.class);
        ArrayList<VirtualLink> virtualLinks = new ArrayList<VirtualLink>();
        virtualLinks.addAll(service.getVirtualLinks(NetworkId.networkId((long)this.networkId)));
        return virtualLinks;
    }

    private void printVirtualLink(VirtualLink virtualLink) {
        this.print(FMT_VIRTUAL_LINK, virtualLink.src().toString(), virtualLink.dst().toString(), virtualLink.state(), virtualLink.tunnelId() == null ? null : virtualLink.tunnelId().toString());
    }
}

