/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.vnet;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.virtual.NetworkId;
import org.onosproject.incubator.net.virtual.VirtualDevice;
import org.onosproject.incubator.net.virtual.VirtualNetworkAdminService;
import org.onosproject.incubator.net.virtual.VirtualNetworkService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;

@Command(scope="onos", name="vnet-create-port", description="Creates a new virtual port in a network.")
public class VirtualPortCreateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="networkId", description="Network ID", required=true, multiValued=false)
    Long networkId = null;
    @Argument(index=1, name="deviceId", description="Virtual Device ID", required=true, multiValued=false)
    String deviceId = null;
    @Argument(index=2, name="portNum", description="Virtual device port number", required=true, multiValued=false)
    Integer portNum = null;
    @Argument(index=3, name="physDeviceId", description="Physical Device ID", required=false, multiValued=false)
    String physDeviceId = null;
    @Argument(index=4, name="physPortNum", description="Physical device port number", required=false, multiValued=false)
    Integer physPortNum = null;

    @Override
    protected void execute() {
        VirtualNetworkAdminService service = VirtualPortCreateCommand.get(VirtualNetworkAdminService.class);
        DeviceService deviceService = VirtualPortCreateCommand.get(DeviceService.class);
        VirtualDevice virtualDevice = this.getVirtualDevice(DeviceId.deviceId((String)this.deviceId));
        Preconditions.checkNotNull((Object)virtualDevice, (Object)"The virtual device does not exist.");
        ConnectPoint realizedBy = null;
        if (this.physDeviceId != null && this.physPortNum != null) {
            Preconditions.checkNotNull((Object)this.physPortNum, (Object)"The physical port does not specified.");
            realizedBy = new ConnectPoint((ElementId)DeviceId.deviceId((String)this.physDeviceId), PortNumber.portNumber((long)this.physPortNum.intValue()));
            Preconditions.checkNotNull((Object)realizedBy, (Object)"The physical port does not exist.");
        }
        service.createVirtualPort(NetworkId.networkId((long)this.networkId), DeviceId.deviceId((String)this.deviceId), PortNumber.portNumber((long)this.portNum.intValue()), realizedBy);
        this.print("Virtual port successfully created.", new Object[0]);
    }

    private VirtualDevice getVirtualDevice(DeviceId aDeviceId) {
        VirtualNetworkService service = VirtualPortCreateCommand.get(VirtualNetworkService.class);
        Set virtualDevices = service.getVirtualDevices(NetworkId.networkId((long)this.networkId));
        for (VirtualDevice virtualDevice : virtualDevices) {
            if (!virtualDevice.id().equals((Object)aDeviceId)) continue;
            return virtualDevice;
        }
        return null;
    }
}

