/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.upgrade.UpgradeAdminService;
import org.onosproject.upgrade.UpgradeService;

@Command(scope="onos", name="issu", description="Manages upgrades")
public class IssuCommand
extends AbstractShellCommand {
    static final String INIT = "init";
    static final String UPGRADE = "upgrade";
    static final String COMMIT = "commit";
    static final String ROLLBACK = "rollback";
    static final String RESET = "reset";
    static final String STATUS = "status";
    static final String VERSION = "version";
    @Argument(index=0, name="command", description="Command name (init|upgrade|commit|rollback|status|version)", required=false, multiValued=false)
    String command = null;

    @Override
    protected void execute() {
        UpgradeService upgradeService = IssuCommand.get(UpgradeService.class);
        UpgradeAdminService upgradeAdminService = IssuCommand.get(UpgradeAdminService.class);
        if (this.command == null) {
            this.print("source=%s, target=%s, status=%s, upgraded=%b, active=%b", upgradeService.getState().source(), upgradeService.getState().target(), upgradeService.getState().status(), upgradeService.isLocalUpgraded(), upgradeService.isLocalActive());
        } else if (this.command.equals(INIT)) {
            upgradeAdminService.initialize();
            this.print("Initialized", new Object[0]);
        } else if (this.command.equals(UPGRADE)) {
            upgradeAdminService.upgrade();
            this.print("Upgraded", new Object[0]);
        } else if (this.command.equals(COMMIT)) {
            upgradeAdminService.commit();
            this.print("Committed version %s", upgradeService.getVersion());
        } else if (this.command.equals(ROLLBACK)) {
            upgradeAdminService.rollback();
            this.print("Rolled back to version %s", upgradeService.getVersion());
        } else if (this.command.equals(RESET)) {
            upgradeAdminService.reset();
            this.print("Reset version %s", upgradeService.getVersion());
        } else if (this.command.equals(STATUS)) {
            this.print("%s", upgradeService.getState().status());
        } else if (this.command.equals(VERSION)) {
            this.print("%s", upgradeService.getVersion());
        } else {
            this.print("Unsupported command: %s", this.command);
        }
    }
}

