/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onosproject.cli;

import java.io.IOException;
import java.io.InputStreamReader;

import org.apache.karaf.shell.commands.Command;
import org.onlab.util.XmlString;

import com.google.common.io.CharStreams;

/**
 * Pretty print previous command output XML.
 */
@Command(scope = "onos", name = "ppxml",
         description = "Pretty print XML output from previous command")
public class PrettyXml extends AbstractShellCommand {

    @Override
    protected void execute() {
        try {
            String xmlS = CharStreams.toString(new InputStreamReader(System.in));

            print("%s", XmlString.prettifyXml(xmlS));
        } catch (IOException e) {
            log.error("Failed parsing XML.", e);
            print("%s", e);
        }
    }

}
