/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.MulticastRouteService;

@Command(scope="onos", name="mcast-show", description="Displays the source, multicast group flows")
public class McastShowCommand
extends AbstractShellCommand {
    private static final String FORMAT_MAPPING = "origin=%s, group=%s, source=%s, sinks=%s";
    @Argument(index=0, name="mcastIp", description="mcast Ip", required=false, multiValued=false)
    String mcastIp;

    @Override
    protected void execute() {
        MulticastRouteService mcastService = McastShowCommand.get(MulticastRouteService.class);
        Set routes = mcastService.getRoutes();
        if (!Strings.isNullOrEmpty((String)this.mcastIp)) {
            IpAddress mcastGroup = IpAddress.valueOf((String)this.mcastIp);
            McastRoute mcastRoute2 = routes.stream().filter(route -> route.group().equals((Object)mcastGroup)).findAny().orElse(null);
            if (mcastRoute2 != null) {
                Set sinks = mcastService.fetchSinks(mcastRoute2);
                this.print(FORMAT_MAPPING, mcastRoute2.type(), mcastRoute2.group(), mcastRoute2.source(), sinks);
            }
            return;
        }
        Set ipv4Routes = routes.stream().filter(mcastRoute -> mcastRoute.group().isIp4()).collect(Collectors.toSet());
        ipv4Routes.stream().sorted(Comparator.comparing(McastRoute::group)).forEach(route -> {
            Set sinks = mcastService.fetchSinks(route);
            this.print(FORMAT_MAPPING, route.type(), route.group(), route.source(), sinks);
        });
        Set ipv6Routes = routes.stream().filter(mcastRoute -> mcastRoute.group().isIp6()).collect(Collectors.toSet());
        ipv6Routes.stream().sorted(Comparator.comparing(McastRoute::group)).forEach(route -> {
            Set sinks = mcastService.fetchSinks(route);
            this.print(FORMAT_MAPPING, route.type(), route.group(), route.source(), sinks);
        });
    }
}

