/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;

@Command(scope="onos", name="annotate-device", description="Annotates network model entities")
public class AnnotateDeviceCommand
extends AbstractShellCommand {
    static final ProviderId PID = new ProviderId("cli", "org.onosproject.cli", true);
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    String uri = null;
    @Argument(index=1, name="key", description="Annotation key", required=true, multiValued=false)
    String key = null;
    @Argument(index=2, name="value", description="Annotation value (null to remove)", required=false, multiValued=false)
    String value = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() {
        DeviceService service = AnnotateDeviceCommand.get(DeviceService.class);
        Device device = service.getDevice(DeviceId.deviceId((String)this.uri));
        DeviceProviderRegistry registry = AnnotateDeviceCommand.get(DeviceProviderRegistry.class);
        AnnotationProvider provider = new AnnotationProvider();
        try {
            DeviceProviderService providerService = (DeviceProviderService)registry.register((Provider)provider);
            providerService.deviceConnected(device.id(), this.description(device, this.key, this.value));
        }
        finally {
            registry.unregister((Provider)provider);
        }
    }

    private DeviceDescription description(Device device, String key, String value) {
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        if (value != null) {
            builder.set(key, value);
        } else {
            builder.remove(key);
        }
        return new DefaultDeviceDescription(device.id().uri(), device.type(), device.manufacturer(), device.hwVersion(), device.swVersion(), device.serialNumber(), device.chassisId(), false, new SparseAnnotations[]{builder.build()});
    }

    private static final class AnnotationProvider
    extends AbstractProvider
    implements DeviceProvider {
        private AnnotationProvider() {
            super(PID);
        }

        public void triggerProbe(DeviceId deviceId) {
        }

        public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
        }

        public boolean isReachable(DeviceId deviceId) {
            return false;
        }

        public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
        }
    }
}

