/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.OptionalInt;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.IntentInstaller;

@Command(scope="onos", name="intent-installers", description="Lists the mapping from intent type to installer component")
public class IntentListInstallers
extends AbstractShellCommand {
    @Override
    protected void execute() {
        IntentExtensionService service = IntentListInstallers.get(IntentExtensionService.class);
        OptionalInt length = service.getInstallers().keySet().stream().mapToInt(s -> s.getName().length()).max();
        if (length.isPresent()) {
            service.getInstallers().entrySet().forEach(e -> this.print("%-" + length.getAsInt() + "s\t%s", ((Class)e.getKey()).getName(), ((IntentInstaller)e.getValue()).getClass().getName()));
        } else {
            this.print("There are no installers registered.", new Object[0]);
        }
    }
}

