/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.StringFilter;
import org.onlab.util.Tools;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.IntentDetailsCommand;
import org.onosproject.cli.net.IntentRemoveCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.OpticalOduIntent;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;

@Command(scope="onos", name="intents", description="Lists the inventory of intents and their states")
public class IntentsListCommand
extends AbstractShellCommand {
    private static final String BOLD = "\u001b[1m";
    private static final String RESET = "\u001b[0m";
    private static final String APP_ID = "\u001b[1mApplication Id:\u001b[0m %s";
    private static final String COMMON_SELECTOR = "\u001b[1mCommon ingress selector:\u001b[0m %s";
    private static final String CP = "\u001b[1mConnect Point:\u001b[0m %s";
    private static final String CONSTRAINTS = "\u001b[1mConstraints:\u001b[0m %s";
    private static final String DST = "\u001b[1mDestination \u001b[0m";
    private static final String EGRESS = "\u001b[1mEgress ";
    private static final String FILTERED_CPS = "connect points and individual selectors\u001b[0m";
    private static final String HOST = "host:\u001b[0m %s";
    private static final String ID = "\u001b[1mId:\u001b[0m %s";
    private static final String INHERITED = "Inherited";
    private static final String INGRESS = "\u001b[1mIngress ";
    private static final String INDENTATION = " -> ";
    private static final String INSTALLABLE = "\u001b[1mInstallable:\u001b[0m %s";
    private static final String KEY = "\u001b[1mKey:\u001b[0m %s";
    private static final String RESOURCES = "\u001b[1mResources:\u001b[0m %s";
    private static final String SELECTOR = "\u001b[1mSelector:\u001b[0m %s";
    private static final String SEPARATOR = StringUtils.repeat((String)"-", (int)172);
    private static final String SPACE = "   ";
    private static final String SRC = "\u001b[1mSource ";
    private static final String STATE = "\u001b[1mState:\u001b[0m %s";
    private static final String TREATMENT = "\u001b[1mTreatment:\u001b[0m %s";
    private static final String TYPE = "\u001b[1mIntent type:\u001b[0m %s";
    private static final String SUMMARY_TITLES = "\u001b[1m" + String.format("\n%1s%21s%14s%14s%14s%14s%14s%14s%14s%14s%14s%14s", "Intent type", "Total", "Installed", "Withdrawn", "Failed", "InstallReq", "Compiling", "Installing", "Recompiling", "WithdrawReq", "Withdrawing", "UnknownState") + "\u001b[0m";
    @Option(name="-i", aliases={"--installable"}, description="Output Installable Intents", required=false, multiValued=false)
    private boolean showInstallable = false;
    @Option(name="-s", aliases={"--summary"}, description="Intents summary", required=false, multiValued=false)
    private boolean intentsSummary = false;
    @Option(name="-m", aliases={"--mini-summary"}, description="Intents mini summary", required=false, multiValued=false)
    private boolean miniSummary = false;
    @Option(name="-p", aliases={"--pending"}, description="Show information about pending intents", required=false, multiValued=false)
    private boolean pending = false;
    @Option(name="-d", aliases={"--details"}, description="Show details for intents, filtered by ID", required=false, multiValued=true)
    private List<String> intentIds = new ArrayList<String>();
    @Option(name="-f", aliases={"--filter"}, description="Filter intents by specific keyword", required=false, multiValued=true)
    private List<String> filter = new ArrayList<String>();
    @Option(name="-r", aliases={"--remove"}, description="Remove and purge intents by specific keyword", required=false, multiValued=false)
    private String remove = null;
    private StringFilter contentFilter;
    private IntentService service;

    @Override
    protected void execute() {
        this.service = IntentsListCommand.get(IntentService.class);
        this.contentFilter = new StringFilter(this.filter, StringFilter.Strategy.AND);
        Iterable intents = this.pending ? this.service.getPending() : this.service.getIntents();
        if (this.remove != null && !this.remove.isEmpty()) {
            this.filter.add(this.remove);
            this.contentFilter = new StringFilter(this.filter, StringFilter.Strategy.AND);
            IntentRemoveCommand intentRemoveCmd = new IntentRemoveCommand();
            if (!this.remove.isEmpty()) {
                intentRemoveCmd.purgeIntentsInteractive(this.filterIntents(this.service));
            }
            return;
        }
        if (!this.intentIds.isEmpty()) {
            IntentDetailsCommand intentDetailsCmd = new IntentDetailsCommand();
            intentDetailsCmd.detailIntents(this.intentIds);
            return;
        }
        if (this.intentsSummary || this.miniSummary) {
            Map<String, IntentSummary> summarized = this.summarize(intents);
            if (this.outputJson()) {
                ObjectNode summaries = this.mapper().createObjectNode();
                summarized.forEach((n, s) -> summaries.set(WordUtils.uncapitalize((String)n), s.json(this.mapper())));
                this.print("%s", summaries);
            } else if (this.miniSummary) {
                StringBuilder builder = new StringBuilder();
                builder.append((CharSequence)summarized.remove("All").miniSummary());
                summarized.values().forEach(s -> builder.append((CharSequence)s.miniSummary()));
                this.print("%s", builder.toString());
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append(SUMMARY_TITLES);
                builder.append('\n').append(SEPARATOR);
                builder.append((CharSequence)summarized.remove("All").summary());
                summarized.values().forEach(s -> builder.append((CharSequence)s.summary()));
                this.print("%s", builder.toString());
            }
            return;
        }
        if (this.outputJson()) {
            this.print("%s", this.json(intents));
        } else {
            for (Intent intent : intents) {
                StringBuilder detailsIntentFormat;
                IntentState state;
                StringBuilder intentFormat = this.fullFormat(intent, state = this.service.getIntentState(intent.key()));
                String formatted = intentFormat.append((CharSequence)(detailsIntentFormat = this.detailsFormat(intent, state))).toString();
                if (!this.contentFilter.filter((Object)formatted)) continue;
                this.print("%s\n", formatted);
            }
        }
    }

    private List<Intent> filterIntents(IntentService service) {
        return this.filterIntents(service.getIntents());
    }

    private List<Intent> filterIntents(Iterable<Intent> intents) {
        return Tools.stream(intents).filter(i -> this.contentFilter.filter(i)).collect(Collectors.toList());
    }

    IntentSummary merge(IntentSummary a, IntentSummary b) {
        IntentSummary m = new IntentSummary((String)MoreObjects.firstNonNull((Object)a.intentType, (Object)b.intentType));
        m.total = a.total + b.total;
        m.installReq = a.installReq + b.installReq;
        m.compiling = a.compiling + b.compiling;
        m.installing = a.installing + b.installing;
        m.installed = a.installed + b.installed;
        m.recompiling = a.recompiling + b.recompiling;
        m.withdrawing = a.withdrawing + b.withdrawing;
        m.withdrawReq = a.withdrawReq + b.withdrawReq;
        m.withdrawn = a.withdrawn + b.withdrawn;
        m.failed = a.failed + b.failed;
        m.unknownState = a.unknownState + b.unknownState;
        return m;
    }

    private static String intentType(Intent intent) {
        return intent.getClass().getSimpleName().replace("Intent", "");
    }

    private Map<String, IntentSummary> summarize(Iterable<Intent> intents) {
        Map<String, List<Intent>> perIntent = Tools.stream(intents).collect(Collectors.groupingBy(IntentsListCommand::intentType));
        List<IntentSummary> collect = perIntent.values().stream().map(il -> il.stream().map(x$0 -> new IntentSummary((Intent)x$0)).reduce(new IntentSummary(), this::merge)).collect(Collectors.toList());
        HashMap<String, IntentSummary> summaries = new HashMap<String, IntentSummary>();
        collect.forEach(is -> summaries.put(((IntentSummary)is).intentType, (IntentSummary)is));
        summaries.put("All", collect.stream().reduce(new IntentSummary("All"), this::merge));
        return summaries;
    }

    private StringBuilder detailsFormat(Intent intent, IntentState state) {
        HostToHostIntent pi;
        ConnectivityIntent ci;
        StringBuilder builder = new StringBuilder();
        if (state == null) {
            return builder;
        }
        if (!intent.resources().isEmpty()) {
            builder.append('\n').append(String.format(RESOURCES, intent.resources()));
        }
        if (intent instanceof ConnectivityIntent) {
            ci = (ConnectivityIntent)intent;
            if (!ci.selector().criteria().isEmpty()) {
                builder.append('\n').append(String.format(COMMON_SELECTOR, this.formatSelector(ci.selector())));
            }
            if (!ci.treatment().allInstructions().isEmpty()) {
                builder.append('\n').append(String.format(TREATMENT, ci.treatment().allInstructions()));
            }
            if (ci.constraints() != null && !ci.constraints().isEmpty()) {
                builder.append('\n').append(String.format(CONSTRAINTS, ci.constraints()));
            }
        }
        if (intent instanceof HostToHostIntent) {
            pi = (HostToHostIntent)intent;
            builder.append('\n').append(String.format("\u001b[1mSource host:\u001b[0m %s", pi.one()));
            builder.append('\n').append(String.format("\u001b[1mDestination \u001b[0mhost:\u001b[0m %s", pi.two()));
        } else if (intent instanceof PointToPointIntent) {
            pi = (PointToPointIntent)intent;
            builder.append('\n').append((CharSequence)this.formatFilteredCps(Sets.newHashSet((Object[])new FilteredConnectPoint[]{pi.filteredIngressPoint()}), INGRESS));
            builder.append('\n').append((CharSequence)this.formatFilteredCps(Sets.newHashSet((Object[])new FilteredConnectPoint[]{pi.filteredEgressPoint()}), EGRESS));
        } else if (intent instanceof MultiPointToSinglePointIntent) {
            pi = (MultiPointToSinglePointIntent)intent;
            builder.append('\n').append((CharSequence)this.formatFilteredCps(pi.filteredIngressPoints(), INGRESS));
            builder.append('\n').append((CharSequence)this.formatFilteredCps(Sets.newHashSet((Object[])new FilteredConnectPoint[]{pi.filteredEgressPoint()}), EGRESS));
        } else if (intent instanceof SinglePointToMultiPointIntent) {
            pi = (SinglePointToMultiPointIntent)intent;
            builder.append('\n').append((CharSequence)this.formatFilteredCps(Sets.newHashSet((Object[])new FilteredConnectPoint[]{pi.filteredIngressPoint()}), INGRESS));
            builder.append('\n').append((CharSequence)this.formatFilteredCps(pi.filteredEgressPoints(), EGRESS));
        } else if (intent instanceof PathIntent) {
            pi = (PathIntent)intent;
            builder.append(String.format("path=%s, cost=%f", pi.path().links(), pi.path().cost()));
        } else if (intent instanceof LinkCollectionIntent) {
            LinkCollectionIntent li = (LinkCollectionIntent)intent;
            builder.append('\n').append(String.format("links=%s", li.links()));
            builder.append('\n').append(String.format(CP, li.egressPoints()));
        } else if (intent instanceof OpticalCircuitIntent) {
            ci = (OpticalCircuitIntent)intent;
            builder.append('\n').append(String.format("src=%s, dst=%s", ci.getSrc(), ci.getDst()));
            builder.append('\n').append(String.format("signal type=%s", ci.getSignalType()));
            builder.append('\n').append(String.format("bidirectional=%s", ci.isBidirectional()));
        } else if (intent instanceof OpticalConnectivityIntent) {
            ci = (OpticalConnectivityIntent)intent;
            builder.append('\n').append(String.format("src=%s, dst=%s", ci.getSrc(), ci.getDst()));
            builder.append('\n').append(String.format("signal type=%s", ci.getSignalType()));
            builder.append('\n').append(String.format("bidirectional=%s", ci.isBidirectional()));
            builder.append('\n').append(String.format("ochSignal=%s", ci.ochSignal()));
        } else if (intent instanceof OpticalOduIntent) {
            ci = (OpticalOduIntent)intent;
            builder.append('\n').append(String.format("src=%s, dst=%s", ci.getSrc(), ci.getDst()));
            builder.append('\n').append(String.format("signal type=%s", ci.getSignalType()));
            builder.append('\n').append(String.format("bidirectional=%s", ci.isBidirectional()));
        }
        List installable = this.service.getInstallableIntents(intent.key());
        installable.stream().filter(i -> this.contentFilter.filter(i));
        if (this.showInstallable && installable != null && !installable.isEmpty()) {
            builder.append('\n').append(String.format(INSTALLABLE, installable));
        }
        return builder;
    }

    private StringBuilder formatFilteredCps(Set<FilteredConnectPoint> fCps, String prefix) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append(FILTERED_CPS);
        fCps.forEach(fCp -> builder.append('\n').append((CharSequence)this.formatFilteredCp((FilteredConnectPoint)fCp)));
        return builder;
    }

    private StringBuilder formatFilteredCp(FilteredConnectPoint fCp) {
        ConnectPoint connectPoint = fCp.connectPoint();
        TrafficSelector selector = fCp.trafficSelector();
        StringBuilder builder = new StringBuilder();
        builder.append(INDENTATION).append(String.format(CP, connectPoint));
        builder.append(SPACE).append(String.format(SELECTOR, this.formatSelector(selector)));
        return builder;
    }

    private StringBuilder formatSelector(TrafficSelector ts) {
        StringBuilder builder = new StringBuilder();
        ArrayList criteria = Lists.newArrayList((Iterable)ts.criteria());
        if (criteria == null || criteria.isEmpty()) {
            builder.append(INHERITED);
            return builder;
        }
        criteria.forEach(c -> {
            builder.append(c.toString());
            if (criteria.indexOf(c) < criteria.size() - 1) {
                builder.append(", ");
            }
        });
        return builder;
    }

    private StringBuilder fullFormat(Intent intent, IntentState state) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(ID, intent.id()));
        if (state != null) {
            builder.append('\n').append(String.format(STATE, state));
        }
        builder.append('\n').append(String.format(KEY, intent.key()));
        builder.append('\n').append(String.format(TYPE, intent.getClass().getSimpleName()));
        builder.append('\n').append(String.format(APP_ID, intent.appId().name()));
        return builder;
    }

    private JsonNode json(Iterable<Intent> intents) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        Tools.stream(intents).filter(intent -> this.contentFilter.filter((Object)this.jsonForEntity(intent, Intent.class).toString())).forEach(intent -> result.add((JsonNode)this.jsonForEntity(intent, Intent.class)));
        return result;
    }

    private class IntentSummary {
        private final String intentType;
        private int total = 0;
        private int installReq = 0;
        private int compiling = 0;
        private int installing = 0;
        private int installed = 0;
        private int recompiling = 0;
        private int withdrawReq = 0;
        private int withdrawing = 0;
        private int withdrawn = 0;
        private int failed = 0;
        private int unknownState = 0;

        IntentSummary(String intentType) {
            this.intentType = intentType;
        }

        IntentSummary(Intent intent) {
            this(IntentsListCommand.intentType(intent));
            if (intentsListCommand.contentFilter.filter((Object)intent)) {
                this.update(intentsListCommand.service.getIntentState(intent.key()));
            }
        }

        IntentSummary() {
            this.intentType = null;
        }

        void update(IntentState intentState) {
            ++this.total;
            switch (intentState) {
                case INSTALL_REQ: {
                    ++this.installReq;
                    break;
                }
                case COMPILING: {
                    ++this.compiling;
                    break;
                }
                case INSTALLING: {
                    ++this.installing;
                    break;
                }
                case INSTALLED: {
                    ++this.installed;
                    break;
                }
                case RECOMPILING: {
                    ++this.recompiling;
                    break;
                }
                case WITHDRAW_REQ: {
                    ++this.withdrawReq;
                    break;
                }
                case WITHDRAWING: {
                    ++this.withdrawing;
                    break;
                }
                case WITHDRAWN: {
                    ++this.withdrawn;
                    break;
                }
                case FAILED: {
                    ++this.failed;
                    break;
                }
                default: {
                    ++this.unknownState;
                }
            }
        }

        StringBuilder summary() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("\n%1s%s%14d%14d%14d%14d%14d%14d%14d%14d%14d%14d", IntentsListCommand.BOLD + this.intentType + IntentsListCommand.RESET, Strings.padStart((String)String.valueOf(this.total), (int)(32 - this.intentType.length()), (char)' '), this.installed, this.withdrawn, this.failed, this.installReq, this.compiling, this.installing, this.recompiling, this.withdrawReq, this.withdrawing, this.unknownState));
            builder.append('\n').append(SEPARATOR);
            return builder;
        }

        StringBuilder miniSummary() {
            StringBuilder builder = new StringBuilder();
            builder.append(IntentsListCommand.BOLD).append(this.intentType).append(IntentsListCommand.RESET).append(" (").append(this.total).append(')').append('\n');
            builder.append('\t').append("installed: ").append(this.installed).append(' ').append("withdrawn: ").append(this.withdrawn).append(' ').append("failed: ").append(this.failed).append('\n');
            builder.append('\t').append("compiling: ").append(this.compiling).append(' ').append("installing: ").append(this.installing).append(' ').append("recompiling: ").append(this.recompiling).append(' ').append("withdrawing: ").append(this.withdrawing).append('\n');
            builder.append('\t').append("installReq: ").append(this.installReq).append(' ').append("withdrawReq: ").append(this.withdrawReq).append(' ').append("unknownState: ").append(this.unknownState).append('\n').append('\n');
            return builder;
        }

        JsonNode json(ObjectMapper mapper) {
            ObjectNode result = mapper.createObjectNode().put("total", this.total).put("installed", this.installed).put("failed", this.failed).put("installReq", this.installReq).put("installing", this.installing).put("compiling", this.compiling).put("recompiling", this.recompiling).put("withdrawReq", this.withdrawReq).put("withdrawing", this.withdrawing).put("withdrawn", this.withdrawn).put("unknownState", this.unknownState);
            return result;
        }
    }
}

